
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega32
;Program type             : Application
;Clock frequency          : 8.000000 MHz
;Memory model             : Small
;Optimize for             : Speed
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 512 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega32
	#pragma AVRPART MEMORY PROG_FLASH 32768
	#pragma AVRPART MEMORY EEPROM 1024
	#pragma AVRPART MEMORY INT_SRAM SIZE 2048
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _pSong=R3
	.DEF _Do_PLAY=R6
	.DEF _key_state=R5
	.DEF _rnd_index=R8
	.DEF _overflow_t0=R7
	.DEF ___PPPTT=R10
	.DEF _x_loc=R9
	.DEF _y_loc=R12
	.DEF _cur_piece=R11
	.DEF _rotate=R14
	.DEF _score=R13

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer1_compa_isr
	JMP  0x00
	JMP  _timer1_ovf_isr
	JMP  _timer0_comp_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_tetris_logo:
	.DB  0x50,0x7,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x81,0x81,0xC1,0x41
	.DB  0x41,0x41,0x41,0x21,0x21,0x21,0x11,0x11
	.DB  0x11,0x11,0x31,0x21,0x21,0x21,0x41,0x41
	.DB  0x41,0x41,0xC1,0x81,0x81,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x80,0x40,0x0,0x10,0x0
	.DB  0x7C,0x7C,0x7E,0x7F,0x78,0xF8,0xF8,0xF8
	.DB  0xF8,0x0,0x0,0x40,0x40,0xE0,0xD0,0x30
	.DB  0xF0,0x10,0x30,0x40,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x1,0x3,0x2,0x6
	.DB  0x4,0x18,0x30,0x60,0x80,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80
	.DB  0x20,0x4,0x2,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0xF,0xF
	.DB  0xF,0x0,0x3A,0x45,0xAA,0x95,0x55,0x3F
	.DB  0x1,0x0,0x80,0x41,0x7F,0xC0,0xF0,0xF0
	.DB  0xF0,0xF0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x1,0x4F,0x7C
	.DB  0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xE0,0x53
	.DB  0x3A,0xBC,0x9C,0x5C,0x70,0xC0,0x80,0x0
	.DB  0x0,0x0,0x0,0x80,0xC0,0x40,0x20,0x10
	.DB  0x8,0x4,0x2,0x1,0x80,0xC0,0x60,0x18
	.DB  0x6,0x7,0x1F,0x40,0x80,0x0,0x1,0x7
	.DB  0xF,0x3F,0x60,0xC0,0x80,0x0,0x0,0x0
	.DB  0x80,0xC0,0x70,0x48,0x66,0x65,0xA4,0x44
	.DB  0x4D,0x50,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x33
	.DB  0x81,0x0,0x0,0x0,0x0,0x0,0x1,0x19
	.DB  0xE,0x6,0x3,0x1,0x0,0x0,0x0,0x0
	.DB  0xC0,0xE0,0xF8,0xFC,0x3,0xFD,0xFC,0xFC
	.DB  0xFC,0xFC,0xFC,0xFC,0xFF,0xC,0xF8,0xC0
	.DB  0x0,0x0,0x6,0xC,0x3,0x6,0xE,0x3
	.DB  0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x1
	.DB  0x3B,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x6,0x8,0x38,0x58,0x98,0x30,0x30
	.DB  0x30,0x64,0x64,0x64,0x30,0x10,0xC,0x3
	.DB  0xFF,0xFF,0xFF,0xFF,0x0,0x7B,0x7B,0x7B
	.DB  0x7B,0x7B,0xFB,0xFB,0xFB,0x0,0x7F,0x7F
	.DB  0x7F,0x7C,0x18,0xF8,0xD0,0xC0,0xC0,0x40
	.DB  0x40,0x20,0xB0,0x50,0x38,0xC,0x2,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x2
	.DB  0x4,0x4,0x8,0x10,0x1F,0x3F,0x3F,0x0
	.DB  0x6F,0x6F,0x6F,0x6F,0xE0,0xFF,0xFF,0xFF
	.DB  0xFF,0xE0,0xEF,0x6F,0x6F,0xF,0x6F,0x6F
	.DB  0x2F,0x2F,0x20,0xF,0x1F,0xF,0xF,0x4
	.DB  0x2,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0
_agape_logo:
	.DB  0x80,0x8,0xFF,0xFF,0xFF,0xFF,0xF,0x7
	.DB  0x7,0x7,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7
	.DB  0x7,0x7,0x7,0x7,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x7,0x7,0xEF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xF9,0xFF,0xFF,0xFF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6
	.DB  0xC6,0x3E,0xFE,0xF0,0x80,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0xE0,0xF0,0x38
	.DB  0xDC,0xEC,0xE4,0x76,0x36,0x36,0x36,0x36
	.DB  0x36,0x36,0x36,0x36,0x36,0x16,0x2,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x80,0xF0
	.DB  0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE
	.DB  0xF0,0x80,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFE,0xFE,0x6,0x6,0xF6,0xF6
	.DB  0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6
	.DB  0xEE,0xDC,0x3C,0xF8,0xF0,0x0,0xFE,0xFE
	.DB  0x6,0x6,0xF6,0xF6,0x36,0x36,0x36,0x36
	.DB  0x36,0x36,0x36,0x16,0xE,0x2,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x7,0x1F,0x7F,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xC0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xE0
	.DB  0xFC,0x3F,0xC7,0xF8,0x7F,0xF,0x1,0x3
	.DB  0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x0
	.DB  0x0,0x0,0x0,0xF8,0xFF,0xFF,0x0,0xFF
	.DB  0xFF,0x1,0x0,0x0,0x0,0xCC,0xCC,0xCC
	.DB  0xCC,0xCC,0xCC,0xCC,0xC,0xFC,0xFC,0x0
	.DB  0x0,0x0,0x0,0x0,0xE0,0xFC,0x3F,0xC7
	.DB  0xF8,0x7F,0xF,0x1,0x3,0x3F,0xFE,0xF1
	.DB  0x9F,0xFF,0xFC,0xE0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFF,0xFF,0x0,0x0,0xFF,0xFF
	.DB  0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C
	.DB  0x9F,0xC7,0xF0,0xFF,0x3F,0x0,0xFF,0xFF
	.DB  0x0,0x0,0xCF,0xCF,0xCC,0xCC,0xCC,0xCC
	.DB  0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x80,0xE0,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F
	.DB  0x1C,0x0,0x0,0x0,0xC0,0xF8,0x7F,0xCF
	.DB  0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60
	.DB  0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF
	.DB  0xF8,0xC0,0x0,0x0,0xF,0x3F,0xF8,0xE7
	.DB  0x9F,0xBE,0x70,0x60,0x60,0x60,0x60,0x60
	.DB  0x60,0x7F,0x7F,0x7F,0x0,0xFF,0xFF,0x0
	.DB  0x0,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F
	.DB  0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F
	.DB  0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x0
	.DB  0x0,0x0,0xFF,0xFF,0x0,0x0,0xFF,0xFF
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x1,0x1,0x0,0x0,0x0,0xFF,0xFF
	.DB  0x0,0x0,0x7F,0x7F,0x60,0x60,0x60,0x60
	.DB  0x60,0x60,0x60,0x60,0x40,0x80,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF8,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0x3,0x1,0x0
	.DB  0x0,0x0,0x0,0x2,0x3,0x3,0x2,0x3
	.DB  0x3,0x0,0x0,0x0,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0xC3,0xC3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x2,0x0,0x0,0x0,0x0,0x1
	.DB  0x1,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x0
	.DB  0x2,0x3,0x3,0x2,0x3,0x3,0x0,0x0
	.DB  0x0,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x2
	.DB  0x0,0x0,0x3,0x3,0x2,0x2,0x3,0x3
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3
	.DB  0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2
	.DB  0x2,0x2,0x2,0x2,0x2,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x1,0xF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x80,0x80,0x80,0xC0,0xC0,0x40,0x20
	.DB  0xA0,0x0,0xFF,0xFF,0x20,0x30,0x60,0x60
	.DB  0xC0,0x80,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x80,0xC0,0xE0,0xF0,0xF0
	.DB  0xF8,0x78,0x78,0x78,0x38,0x38,0x98,0xE0
	.DB  0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0
	.DB  0xF0,0x80,0x0,0x0,0xE0,0xF8,0xF8,0xF8
	.DB  0xF8,0xF0,0xE0,0xF8,0xF8,0xF8,0x38,0x0
	.DB  0x0,0xE0,0xF0,0xF8,0xF8,0xF8,0x78,0x78
	.DB  0x38,0x80,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8
	.DB  0xF8,0xF8,0xF0,0xF0,0x80,0x0,0x0,0xC0
	.DB  0xF0,0xF8,0xF8,0xF8,0x38,0x0,0x0,0x0
	.DB  0x80,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xB8
	.DB  0xB8,0x38,0x18,0x0,0x0,0xE0,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x1F
	.DB  0x1F,0x7F,0xFF,0xFF,0x71,0x6E,0xFE,0xFF
	.DB  0xD7,0xD7,0xD7,0xD7,0xF6,0xFF,0xFE,0x6E
	.DB  0x7F,0x3F,0x3F,0xBE,0x9E,0xD8,0xC0,0x0
	.DB  0x0,0x0,0x0,0x1F,0x3F,0x7F,0x7F,0x7F
	.DB  0x79,0x70,0x20,0x0,0x0,0x0,0xF,0x3F
	.DB  0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F
	.DB  0x1F,0x3,0x78,0x7F,0x7F,0x3F,0xF,0x1F
	.DB  0x7F,0x7F,0x7F,0x3F,0x1F,0x3,0x70,0x70
	.DB  0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x3C,0x0
	.DB  0x0,0xF,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C
	.DB  0x7F,0x3F,0x3F,0x1F,0x3,0x78,0x7F,0x7F
	.DB  0x7F,0x7F,0x7F,0x78,0x78,0x78,0x0,0x78
	.DB  0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x77,0x77
	.DB  0x33,0x0,0x0,0x0,0x0,0xF,0x3F,0xFF
	.DB  0xFF,0xFF,0x7F,0x7F,0xFF,0xFC,0xC0,0xC0
	.DB  0xC0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80
	.DB  0x80,0x80,0x80,0xFB,0xF2,0xFA,0xFB,0xFB
	.DB  0xFD,0xFD,0xBD,0xBF,0xBE,0xBE,0x9E,0x9E
	.DB  0x8F,0x8F,0x87,0x87,0x83,0x81,0x80,0x80
	.DB  0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x80,0x80,0x80
	.DB  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80
	.DB  0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0
	.DB  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0
	.DB  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0
	.DB  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0
	.DB  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xE0,0xE0
	.DB  0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0
	.DB  0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0
	.DB  0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xF0,0xF8
	.DB  0xFF,0xFF
_maze_logo:
	.DB  0x50,0x7,0x51,0xA1,0x51,0xA1,0x51,0xA1
	.DB  0x51,0xA1,0x51,0xE1,0x51,0xB1,0x51,0x1
	.DB  0x1,0xA1,0x41,0x81,0x41,0x81,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x81,0x41,0xE1
	.DB  0x51,0xA1,0x1,0x1,0x1,0xB9,0x55,0xF9
	.DB  0x55,0xB9,0x55,0xA9,0x55,0xB9,0x55,0xA9
	.DB  0xD5,0xA9,0x55,0xA,0x55,0x22,0x55,0xAA
	.DB  0x55,0x2B,0x55,0xAF,0x55,0xBB,0x55,0x0
	.DB  0x0,0xBB,0x55,0xAF,0x55,0xBB,0x55,0xAA
	.DB  0x54,0x20,0x50,0x0,0x0,0xA0,0x40,0x80
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0
	.DB  0x0,0x20,0x54,0x8A,0x55,0x2B,0x55,0xAE
	.DB  0x55,0xBF,0x0,0x0,0x0,0xBB,0x55,0xAA
	.DB  0x55,0xAB,0x55,0xAA,0x55,0xAA,0x55,0x8A
	.DB  0x55,0xAA,0x55,0x0,0x55,0x22,0x55,0x88
	.DB  0x55,0x22,0x55,0xAA,0x55,0xBB,0x1,0x0
	.DB  0x0,0xBB,0x55,0xAA,0x55,0x22,0x55,0x0
	.DB  0x55,0x2,0x55,0x0,0x0,0xAA,0x55,0xAA
	.DB  0x55,0x0,0x0,0xB0,0x50,0x20,0x50,0x80
	.DB  0x50,0x20,0x50,0xA0,0x50,0x20,0x50,0xA0
	.DB  0x50,0x0,0x0,0xAA,0x55,0xBB,0x0,0x0
	.DB  0x55,0x2,0x55,0x0,0x55,0x22,0x55,0xAA
	.DB  0x55,0xBF,0x0,0x0,0x0,0xBB,0x55,0xAA
	.DB  0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0x0
	.DB  0x55,0xAA,0x55,0x0,0x55,0x22,0x55,0x88
	.DB  0x55,0x22,0x55,0xAA,0x55,0xBB,0x50,0x0
	.DB  0x0,0xBB,0x55,0xAA,0x55,0xA2,0x55,0x80
	.DB  0x55,0x22,0x55,0x0,0x0,0x6A,0x55,0x2A
	.DB  0x55,0x0,0x0,0x6A,0x55,0x22,0x55,0x20
	.DB  0x55,0x22,0x55,0x22,0x55,0x22,0x55,0x2A
	.DB  0x55,0x0,0x0,0xA,0x15,0x3A,0x0,0x0
	.DB  0x55,0x0,0x55,0x80,0x55,0x22,0x55,0xAA
	.DB  0x55,0xFF,0x0,0x0,0x0,0xBB,0x55,0xAA
	.DB  0x55,0xAA,0x55,0x8A,0x55,0x22,0x55,0x80
	.DB  0x55,0xAA,0x55,0xA8,0x55,0xA2,0x55,0xAA
	.DB  0x55,0xAA,0x55,0xEA,0x55,0xBB,0x55,0x0
	.DB  0x0,0x2B,0x55,0xEE,0x55,0x3A,0x55,0x2A
	.DB  0x15,0x2,0x5,0x2,0x0,0x0,0x0,0x0
	.DB  0x15,0x2A,0x35,0xE,0x35,0x22,0x15,0x2A
	.DB  0x15,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A
	.DB  0x15,0x2A,0x14,0x28,0x10,0x20,0x0,0x0
	.DB  0x1,0x2,0x5,0xA,0x15,0x3A,0x55,0xEA
	.DB  0x55,0xBB,0x0,0x0,0x0,0xBB,0x55,0xEA
	.DB  0x55,0xAA,0x55,0xAA,0x55,0xA2,0x55,0xAA
	.DB  0x55,0xAA,0x5,0x2,0x5,0x2,0x5,0x2
	.DB  0x5,0x3,0x5,0x7,0x5,0x3,0x5,0x0
	.DB  0x0,0x0,0x1,0x2,0x1,0x0,0x0,0x0
	.DB  0x50,0x38,0x54,0x6A,0x54,0x7A,0x55,0x6A
	.DB  0x55,0x2A,0x55,0x68,0x55,0x22,0x55,0x68
	.DB  0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68
	.DB  0x55,0x2A,0x55,0x6A,0x55,0x3A,0x55,0x6A
	.DB  0x14,0x38,0x10,0x0,0x0,0x0,0x0,0x0
	.DB  0x1,0x3,0x0,0x0,0x0,0xB,0x5,0xF
	.DB  0x5,0xB,0x5,0xE,0x5,0xA,0x5,0xA
	.DB  0x5,0xA,0x54,0xEE,0x54,0xFA,0x54,0xFE
	.DB  0x14,0xA,0x0,0x0,0x0,0x80,0x40,0xA0
	.DB  0x50,0xB8,0x54,0xAC,0x54,0xB8,0x54,0xA8
	.DB  0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8
	.DB  0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8
	.DB  0x54,0xA8,0x54,0xA8,0x50,0xAC,0x54,0xA8
	.DB  0x54,0xA8,0x54,0xA8,0x54,0xB0,0x54,0xA8
	.DB  0x54,0xB8,0x54,0xA8,0x54,0xB8,0x54,0xF8
	.DB  0x50,0xA0,0x40,0x80,0x0,0x0,0x50,0xA8
	.DB  0x70,0xF8,0xD0,0xF8,0x54,0xB8,0x54,0xE8
	.DB  0x54,0xB8
_puzzle_logo:
	.DB  0x50,0x7,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0xFF,0x77,0x3,0x57,0xB,0x57,0x3
	.DB  0x57,0x3,0x17,0xA5,0x15,0x19,0x19,0x1
	.DB  0x1,0x1,0x71,0xB1,0xB1,0x21,0x71,0x21
	.DB  0x61,0x21,0x61,0x81,0x41,0x81,0xC1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x0,0x0,0xC0,0xA0,0x70,0x8
	.DB  0x58,0x18,0x50,0x8,0x50,0x10,0x60,0x20
	.DB  0x7D,0xE,0x55,0x0,0x55,0x0,0x55,0x0
	.DB  0x54,0x0,0x55,0x2B,0x5C,0x20,0x70,0x60
	.DB  0x60,0xE0,0x78,0x3F,0x5F,0x0,0x51,0x0
	.DB  0x44,0x0,0x15,0x2,0x45,0x0,0x15,0xA3
	.DB  0xFD,0xA,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x80
	.DB  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80
	.DB  0x0,0x0,0x0,0x0,0x0,0xE0,0xE0,0x20
	.DB  0x60,0x20,0x0,0x0,0x1,0x6,0x15,0x10
	.DB  0x10,0x0,0x11,0x18,0xC,0xA8,0xFD,0x0
	.DB  0x44,0x0,0x55,0x0,0x55,0x0,0x55,0x0
	.DB  0x55,0x0,0x55,0x2,0x45,0x0,0x55,0x0
	.DB  0x55,0x0,0x55,0x0,0xF5,0xA8,0x7D,0x8
	.DB  0xC,0xC,0x1D,0x18,0x34,0x20,0x71,0xA
	.DB  0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x7F,0xE0,0x51,0x0
	.DB  0x55,0x0,0x55,0x0,0x55,0x0,0x55,0xFA
	.DB  0xC1,0x80,0x80,0x0,0x0,0x0,0x7,0x8E
	.DB  0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x40,0xA8,0x9F,0x8B,0xD1,0x80
	.DB  0xC4,0x80,0xD5,0x80,0x45,0x0,0x15,0x0
	.DB  0x44,0x0,0x55,0x0,0x55,0x0,0x55,0x0
	.DB  0x55,0x0,0x55,0x0,0x57,0xE,0x5C,0x8
	.DB  0x5C,0xC,0x5C,0x8,0x5C,0xA8,0x50,0x0
	.DB  0x0,0x0,0x0,0x80,0xC0,0x60,0x70,0x20
	.DB  0x70,0x20,0x70,0x20,0x70,0x2F,0x7F,0x0
	.DB  0x54,0x0,0x55,0x20,0x55,0x88,0x55,0x22
	.DB  0x55,0x88,0x55,0xAB,0x55,0x8B,0x55,0xA3
	.DB  0x55,0xA8,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1,0xA0,0x7D,0x2E,0x5F,0xA
	.DB  0x40,0x0,0x55,0x20,0x7D,0x80,0x5,0x8
	.DB  0xC,0x8,0x31,0x20,0x55,0xA0,0xD5,0xC0
	.DB  0x44,0x20,0x35,0xA,0x7,0x0,0x0,0x0
	.DB  0x0,0x0,0x1,0xB,0x1F,0x28,0x71,0x20
	.DB  0x34,0x0,0x15,0x8,0x1D,0x8,0xF9,0xF0
	.DB  0x45,0x0,0x55,0x22,0x55,0x0,0x55,0x22
	.DB  0x55,0x88,0x55,0x22,0x55,0x88,0x55,0x22
	.DB  0x55,0x88,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x3,0xF,0x8,0x11,0x10
	.DB  0x14,0x8,0x1D,0x8,0xD,0x2,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x80,0x80,0x80,0x80,0x80,0x80,0x80
	.DB  0x80,0x80,0x80,0x80,0x0,0x80,0xFF,0x2B
	.DB  0x44,0x80,0xD5,0xC2,0xD5,0xE0,0x75,0x62
	.DB  0x75,0x68,0x75,0xE2,0xF5,0x8,0x55,0x22
	.DB  0xD5,0x88,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x1C,0xA8
	.DB  0x44,0x2,0x17,0x2,0x57,0x2,0x51,0x3
	.DB  0x55,0xA2,0xFE,0xE,0x4,0x0,0x0,0x0
	.DB  0x7,0xC,0xFD,0xE0,0x54,0x0,0x51,0x0
	.DB  0x55,0x0,0x51,0x20,0x55,0x8B,0x7F,0xBA
	.DB  0xF7,0x83,0xD7,0x20,0x54,0x80,0x55,0x20
	.DB  0x55,0x28,0x7F,0xC3,0xD5,0x80,0x55,0xA2
	.DB  0x57,0x83
_breakout_logo:
	.DB  0x50,0x7,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x81,0xC1,0xE1,0xF1,0xF1,0xF9,0xF9
	.DB  0xF9,0xF9,0x79,0xF9,0xF9,0xF9,0xF9,0xF1
	.DB  0xF1,0xE1,0xC1,0x81,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0xFC
	.DB  0xFF,0xFF,0xFF,0x1F,0x7,0x3,0x1,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x3
	.DB  0x7,0x1F,0xFF,0xFF,0xFF,0xFC,0xC0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x80,0x80,0xC0,0xC0,0x60
	.DB  0x60,0x0,0x0,0x0,0x0,0x0,0x7,0x7F
	.DB  0xFF,0xFF,0xFE,0xF8,0xC0,0x80,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80
	.DB  0xC0,0xF8,0xFE,0xFF,0xFF,0x7F,0x7,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80
	.DB  0xC0,0xC0,0x60,0x70,0x30,0x18,0x18,0xC
	.DB  0xE,0x6,0x83,0x83,0xC1,0xE1,0x60,0x70
	.DB  0x30,0x18,0x1C,0x88,0x80,0x80,0x0,0x0
	.DB  0x0,0x3,0x7,0xF,0xF,0x1F,0x3F,0x3F
	.DB  0x3E,0x3E,0x3C,0x3E,0x3E,0x3F,0x3F,0x1F
	.DB  0xF,0xF,0x7,0x3,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x1
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2
	.DB  0x6,0x3,0x3,0x1,0x0,0x0,0x0,0xC
	.DB  0xE,0x6,0x3,0x3,0x1,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFE,0xFF,0xFF,0x57,0xAF,0x57,0xAF
	.DB  0x57,0xAF,0x57,0xAF,0x57,0xFF,0x7,0xFF
	.DB  0xFF,0xFF,0x57,0xAF,0x57,0xAF,0x57,0xAF
	.DB  0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF
	.DB  0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF
	.DB  0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF
	.DB  0x57,0xAF,0x57,0xAF,0x57,0xAF,0xFF,0xFF
	.DB  0x7,0xFF,0x57,0xAF,0x57,0xAF,0x57,0xAF
	.DB  0x57,0xAF,0x57,0xFF,0xFF,0xFF,0xFE,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x1F,0x1F,0x3F,0x35,0x3A,0x35,0x3A
	.DB  0x35,0x3A,0x35,0x3A,0x35,0x3F,0x30,0x3F
	.DB  0x3F,0x3F,0x35,0x3A,0x35,0x3A,0x35,0x3A
	.DB  0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A
	.DB  0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A
	.DB  0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A
	.DB  0x35,0x3A,0x35,0x3A,0x35,0x3A,0x3F,0x3F
	.DB  0x30,0x3F,0x35,0x3A,0x35,0x3A,0x35,0x3A
	.DB  0x35,0x3A,0x35,0x3F,0x3F,0x3F,0x1F,0x0
	.DB  0x0,0x0
_buttom:
	.DB  0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0
	.DB  0xFE,0xFE,0xFC,0xF8,0xF0,0xE0,0xC0,0x80
	.DB  0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF
	.DB  0x7F,0x7F,0x3F,0x1F,0xF,0x7,0x3,0x1
	.DB  0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10
	.DB  0x1E,0x2,0x4,0x8,0x10,0x20,0x40,0x80
	.DB  0xF,0x8,0x8,0x8,0x8,0x8,0x8,0x8
	.DB  0x78,0x40,0x20,0x10,0x8,0x4,0x2,0x1
	.DB  0x80,0xC0,0xE0,0xF0,0xF8,0xFC,0xFE,0xFE
	.DB  0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0
	.DB  0x1,0x3,0x7,0xF,0x1F,0x3F,0x7F,0x7F
	.DB  0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF
	.DB  0x80,0x40,0x20,0x10,0x8,0x4,0x2,0x1E
	.DB  0x10,0x10,0x10,0x10,0x10,0x10,0x10,0xF0
	.DB  0x1,0x2,0x4,0x8,0x10,0x20,0x40,0x78
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x8,0xF
_start:
	.DB  0x2,0x4,0x1A,0x8,0x27,0x8,0x23,0x8
	.DB  0x1F,0x8,0x1D,0x4,0x1A,0x4,0x27,0x4
	.DB  0x27,0x4,0x17,0x8,0x1D,0x8,0x1A,0x8
	.DB  0x17,0x8,0x15,0x4,0x13,0x4,0x27,0x4
	.DB  0x27,0x4,0x1D,0x8,0x1A,0x8,0x1D,0x8
	.DB  0x1F,0x8,0x23,0x4,0x1F,0x8,0x1D,0x8
	.DB  0x1F,0x8,0x23,0x8,0x27,0x4,0x2A,0x8
	.DB  0x27,0x8,0x23,0x8,0x1F,0x8,0x27,0x4
	.DB  0x1F,0x2,0x23,0x0,0x1
_key_sound:
	.DB  0x0,0x20,0x59,0x0,0x0
_tetris_one:
	.DB  0x1,0x20,0x59,0x20,0x27,0x0,0x0
_maze_sound:
	.DB  0x2,0x3,0xE,0x3,0x9,0x3,0xB,0x5
	.DB  0xD,0x3,0xE,0x5,0xB,0x3,0xD,0x3
	.DB  0xF,0x3,0xE,0x3,0x9,0x3,0xB,0x5
	.DB  0xD,0x5,0xE,0x5,0xD,0x5,0xE,0x5
	.DB  0xD,0x3,0xB,0x3,0xD,0x5,0x11,0x5
	.DB  0xF,0x5,0xE,0x5,0xD,0x3,0xF,0x3
	.DB  0x13,0x2,0x11,0x5,0xB,0x5,0xE,0x5
	.DB  0xB,0x5,0xE,0x3,0xD,0x3,0xF,0x3
	.DB  0x13,0x5,0xD,0x3,0xE,0x5,0x11,0x0
	.DB  0x1
_tetris_sound:
	.DB  0x2,0x4,0x13,0x2,0xE,0x8,0xE,0x4
	.DB  0xE,0x4,0xB,0x2,0xD,0x8,0xE,0x4
	.DB  0xD,0x8,0xB,0x8,0xD,0x2,0xE,0x8
	.DB  0xE,0x4,0xB,0x4,0x9,0x2,0x8,0x8
	.DB  0x1,0x4,0x8,0x2,0x9,0x8,0xB,0x4
	.DB  0xB,0x4,0xE,0x2,0xD,0x8,0xE,0x4
	.DB  0xD,0x8,0xB,0x8,0xD,0x2,0xE,0x8
	.DB  0x11,0x4,0x11,0x4,0x13,0x2,0xE,0x4
	.DB  0x1,0x0,0x1
_puzzle_sound:
	.DB  0x2,0x4,0xC,0x4,0xD,0x4,0xC,0x4
	.DB  0xD,0x4,0xE,0x4,0xF,0x4,0xE,0x4
	.DB  0x13,0x4,0x19,0x4,0x13,0x4,0xE,0x4
	.DB  0xC,0x4,0xB,0x4,0xE,0x4,0xE,0x4
	.DB  0x7,0x4,0x7,0x4,0x9,0x4,0xD,0x4
	.DB  0xF,0x4,0xD,0x4,0xF,0x4,0x13,0x4
	.DB  0xD,0x4,0xE,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0x1D,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0xC,0x4,0xD,0x4,0xC,0x4
	.DB  0xD,0x4,0xE,0x4,0xF,0x4,0xE,0x4
	.DB  0x13,0x4,0x19,0x4,0x13,0x4,0xE,0x4
	.DB  0xC,0x4,0xB,0x4,0xE,0x4,0xE,0x4
	.DB  0x7,0x4,0x7,0x4,0x9,0x4,0xD,0x4
	.DB  0xF,0x4,0xD,0x4,0xF,0x4,0x13,0x4
	.DB  0xD,0x4,0xE,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0x1D,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0xC,0x4,0xD,0x4,0xC,0x4
	.DB  0xD,0x4,0xE,0x4,0xF,0x4,0xE,0x4
	.DB  0x13,0x4,0x19,0x4,0x13,0x4,0xE,0x4
	.DB  0xC,0x4,0xB,0x4,0xE,0x4,0xE,0x4
	.DB  0x7,0x4,0x7,0x4,0x9,0x4,0xD,0x4
	.DB  0xF,0x4,0xD,0x4,0xF,0x4,0x13,0x4
	.DB  0xD,0x4,0xE,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0x1D,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0xC,0x4,0xD,0x4,0xC,0x4
	.DB  0xD,0x4,0xE,0x4,0xF,0x4,0xE,0x4
	.DB  0x13,0x4,0x19,0x4,0x13,0x4,0xE,0x4
	.DB  0xC,0x4,0xB,0x4,0xE,0x4,0xE,0x4
	.DB  0x7,0x4,0x7,0x4,0x9,0x4,0xD,0x4
	.DB  0xF,0x4,0xD,0x4,0xF,0x4,0x13,0x4
	.DB  0xD,0x4,0xE,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x4,0x1D,0x4,0x7,0x4,0x7,0x4
	.DB  0x6,0x0,0x1
_font:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x8,0x2A,0x1C,0x2A,0x8,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x30
	.DB  0x30,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x3E,0x51,0x49,0x45,0x3E,0x0,0x42,0x7F
	.DB  0x40,0x0,0x42,0x61,0x51,0x49,0x46,0x21
	.DB  0x41,0x45,0x4B,0x31,0x18,0x14,0x12,0x7F
	.DB  0x10,0x27,0x45,0x45,0x45,0x39,0x3C,0x4A
	.DB  0x49,0x49,0x30,0x1,0x71,0x9,0x5,0x3
	.DB  0x36,0x49,0x49,0x49,0x36,0x6,0x49,0x49
	.DB  0x29,0x1E,0x0,0x36,0x36,0x0,0x0,0x0
	.DB  0x56,0x36,0x0,0x0,0x0,0x8,0x14,0x22
	.DB  0x41,0x14,0x14,0x14,0x14,0x14,0x41,0x22
	.DB  0x14,0x8,0x0,0x2,0x1,0x51,0x9,0x6
	.DB  0x32,0x49,0x79,0x41,0x3E,0x7E,0x11,0x11
	.DB  0x11,0x7E,0x7F,0x49,0x49,0x49,0x36,0x3E
	.DB  0x41,0x41,0x41,0x22,0x7F,0x41,0x41,0x22
	.DB  0x1C,0x7F,0x49,0x49,0x49,0x41,0x7F,0x9
	.DB  0x9,0x1,0x1,0x3E,0x41,0x41,0x51,0x32
	.DB  0x7F,0x8,0x8,0x8,0x7F,0x0,0x41,0x7F
	.DB  0x41,0x0,0x20,0x40,0x41,0x3F,0x1,0x7F
	.DB  0x8,0x14,0x22,0x41,0x7F,0x40,0x40,0x40
	.DB  0x40,0x7F,0x2,0x4,0x2,0x7F,0x7F,0x4
	.DB  0x8,0x10,0x7F,0x3E,0x41,0x41,0x41,0x3E
	.DB  0x7F,0x9,0x9,0x9,0x6,0x3E,0x41,0x51
	.DB  0x21,0x5E,0x7F,0x9,0x19,0x29,0x46,0x46
	.DB  0x49,0x49,0x49,0x31,0x1,0x1,0x7F,0x1
	.DB  0x1,0x3F,0x40,0x40,0x40,0x3F,0x1F,0x20
	.DB  0x40,0x20,0x1F,0x7F,0x20,0x18,0x20,0x7F
	.DB  0x63,0x14,0x8,0x14,0x63,0x3,0x4,0x78
	.DB  0x4,0x3,0x61,0x51,0x49,0x45,0x43,0x0
	.DB  0x0,0x7F,0x41,0x41,0x2,0x4,0x8,0x10
	.DB  0x20,0x41,0x41,0x7F,0x0,0x0,0x4,0x2
	.DB  0x1,0x2,0x4,0x40,0x40,0x40,0x40,0x40
	.DB  0x0,0x1,0x2,0x4,0x0,0x20,0x54,0x54
	.DB  0x54,0x78,0x7F,0x48,0x44,0x44,0x38,0x38
	.DB  0x44,0x44,0x44,0x20,0x38,0x44,0x44,0x48
	.DB  0x7F,0x38,0x54,0x54,0x54,0x18,0x8,0x7E
	.DB  0x9,0x1,0x2,0x8,0x14,0x54,0x54,0x3C
	.DB  0x7F,0x8,0x4,0x4,0x78,0x0,0x44,0x7D
	.DB  0x40,0x0,0x20,0x40,0x44,0x3D,0x0,0x0
	.DB  0x7F,0x10,0x28,0x44,0x0,0x41,0x7F,0x40
	.DB  0x0,0x7C,0x4,0x18,0x4,0x78,0x7C,0x8
	.DB  0x4,0x4,0x78,0x38,0x44,0x44,0x44,0x38
	.DB  0x7C,0x14,0x14,0x14,0x8,0x8,0x14,0x14
	.DB  0x18,0x7C,0x7C,0x8,0x4,0x4,0x8,0x48
	.DB  0x54,0x54,0x54,0x20,0x4,0x3F,0x44,0x40
	.DB  0x20,0x3C,0x40,0x40,0x20,0x7C,0x1C,0x20
	.DB  0x40,0x20,0x1C,0x3C,0x40,0x30,0x40,0x3C
	.DB  0x44,0x28,0x10,0x28,0x44,0xC,0x50,0x50
	.DB  0x50,0x3C,0x44,0x64,0x54,0x4C,0x44,0x0
	.DB  0x8,0x36,0x41,0x0,0x0,0x0,0x7F,0x0
	.DB  0x0,0x0,0x41,0x36,0x8,0x0,0x8,0x8
	.DB  0x2A,0x1C,0x8,0x8,0x1C,0x2A,0x8,0x8
_rnd_table:
	.DB  0x4,0xAD,0x64,0x65,0x55,0x95,0xC8,0x43
	.DB  0x29,0x3D,0x8,0xE8,0xB3,0xDD,0x7F,0x5A
	.DB  0xDF,0xAC,0x0,0xD8,0xE9,0xB7,0xF3,0x7A
	.DB  0xED,0xE2,0x6,0xF0,0x8C,0xAE,0xAF,0xD3
	.DB  0x9D,0x13,0xCC,0xB4,0x2C,0xCB,0x60,0xB5
	.DB  0x23,0x87,0xD0,0x24,0x9F,0x27,0xB2,0x59
	.DB  0x70,0xD7,0x6A,0xC3,0x4B,0xB9,0x77,0x72
	.DB  0x8E,0x1A,0x14,0x16,0xC9,0xB1,0xA4,0x22
	.DB  0xC5,0x30,0xDE,0x33,0x82,0x10,0x78,0xC7
	.DB  0xCA,0x6D,0xD,0x44,0xA,0x89,0x5C,0x1
	.DB  0xBD,0xF6,0xA0,0x5D,0x96,0x93,0x2F,0x9A
	.DB  0x3C,0x9C,0xD9,0xFD,0x86,0xCD,0x58,0x40
	.DB  0xB8,0x81,0x3B,0x7E,0x6E,0x1B,0x7C,0x36
	.DB  0x2A,0x20,0x42,0xCF,0x8F,0x73,0x46,0xEB
	.DB  0x5B,0x63,0xBE,0xFC,0x48,0xA9,0x75,0x2E
	.DB  0x5E,0x3,0xBB,0xD2,0x80,0x53,0xA2,0x34
	.DB  0x52,0x4D,0xD6,0xF8,0x25,0xC0,0x6F,0xBA
	.DB  0x12,0x17,0xC4,0xF1,0xE5,0x94,0xB0,0x6B
	.DB  0x7,0x4F,0x69,0xA7,0xFA,0x1E,0x3E,0x90
	.DB  0x41,0x47,0x61,0x11,0xB,0x18,0x66,0x67
	.DB  0xEE,0xE6,0x8B,0x37,0xA3,0x9B,0xD1,0xFE
	.DB  0x38,0x19,0x5F,0xEC,0xBF,0xD5,0x7B,0x4E
	.DB  0x98,0xE4,0x49,0xC1,0xE,0xE1,0x7D,0x45
	.DB  0x68,0xEF,0xDC,0xC6,0xD4,0xA5,0xFB,0xF5
	.DB  0xA6,0xA1,0x15,0xCE,0xF7,0xF9,0x9E,0x62
	.DB  0xDB,0x28,0xAA,0x3A,0x39,0x97,0xF4,0xA8
	.DB  0xBC,0x56,0x2D,0xDA,0x85,0x3F,0x88,0x51
	.DB  0xE0,0x92,0x76,0x35,0xE3,0x57,0x4C,0x4A
	.DB  0x83,0x84,0x1C,0x8D,0x21,0x31,0x32,0xC2
	.DB  0x8A,0xB6,0x79,0xE7,0xF,0x74,0x6C,0x2B
	.DB  0xEA,0x91,0x71,0x1D,0x26,0xF2,0x2,0x5
	.DB  0x1F,0xAB,0x50,0xC,0x54,0x99,0x9,0x0
_maze_levels:
	.DB  0x2,0x1,0x10,0x8,0xD,0x8,0x3,0x3
	.DB  0x1,0x5,0x9,0x5,0x9,0x3,0x1,0x7
	.DB  0xB,0x1,0x3,0x5,0xA,0x4,0x9,0x1
	.DB  0x2,0x4,0xC,0xA,0x4,0x9,0x2,0x3
	.DB  0x5,0xA,0x5,0xC,0xD,0xC,0xC,0xC
	.DB  0x9,0x6,0xA,0x5,0xA,0x6,0x9,0x5
	.DB  0xC,0x9,0x6,0xE,0xC,0xA,0x2,0x6
	.DB  0xA,0x1,0x5,0xA,0x3,0x5,0xC,0xA
	.DB  0x2,0x6,0x9,0x5,0x8,0x7,0x9,0x3
	.DB  0x1,0x6,0xA,0x3,0x5,0xC,0xC,0x9
	.DB  0x3,0x5,0xC,0xC,0x8,0x5,0xA,0x3
	.DB  0x2,0x3,0x5,0x9,0x6,0xC,0xA,0x2
	.DB  0x5,0xC,0xC,0xC,0x8,0x4,0x9,0x3
	.DB  0x5,0x9,0x4,0xA,0x1,0x0,0x7,0xD
	.DB  0xA,0x2,0x6,0xC,0xE,0xA,0x2,0x3
	.DB  0x2,0x6,0xA,0x7,0xE,0xA,0x3,0x6
	.DB  0xF,0xB,0x7,0xC,0x8,0x1,0x8,0x8
	.DB  0xD,0x9,0x1,0x3,0x1,0x3,0x5,0xA
	.DB  0x3,0x5,0xD,0x9,0x3,0x3,0x3,0x5
	.DB  0xC,0xA,0x2,0x5,0xA,0x5,0xA,0x1
	.DB  0x7,0xA,0x4,0xA,0x3,0x5,0x9,0x6
	.DB  0xC,0x9,0x1,0x0,0x3,0x6,0x9,0x6
	.DB  0x9,0x3,0x2,0x1,0x3,0x4,0x8,0x7
	.DB  0xA,0x4,0xC,0xA,0x1,0x5,0x8,0x5
	.DB  0xA,0x3,0x5,0x8,0x5,0xC,0xA,0x5
	.DB  0x9,0x6,0xA,0x3,0x6,0xA,0x6,0x8
	.DB  0x3,0x7,0xC,0xE,0xA,0x4,0x9,0x4
	.DB  0xC,0x9,0x3,0x1,0x3,0x3,0x5,0xA
	.DB  0x5,0x9,0x4,0x9,0x3,0x6,0xC,0xC
	.DB  0x8,0x6,0xD,0xA,0x3,0x5,0xA,0x5
	.DB  0xA,0x6,0x8,0x2,0x3,0x1,0x6,0xC
	.DB  0xE,0xB,0x6,0xF,0xB,0x2,0x7,0xC
	.DB  0xB,0x7,0xA,0x3,0x3,0x2,0x7,0xE
	.DB  0x1,0x2,0x10,0x4,0x9,0x5,0x9,0x3
	.DB  0x1,0x5,0x9,0x5,0xB,0x5,0xD,0x9
	.DB  0x5,0xD,0xD,0xD,0x6,0xA,0x4,0x9
	.DB  0x2,0x4,0xC,0xA,0x1,0x0,0x6,0xC
	.DB  0xC,0xC,0xA,0x6,0x9,0x5,0xC,0xA
	.DB  0x1,0x6,0x8,0x5,0xA,0x2,0x5,0xC
	.DB  0xC,0x8,0x3,0x5,0x8,0x4,0xE,0x9
	.DB  0x0,0x5,0xC,0xC,0x9,0x3,0x4,0xC
	.DB  0xE,0x8,0x3,0x2,0xC,0xC,0x9,0x6
	.DB  0xC,0xA,0x4,0xC,0xA,0x5,0xC,0xC
	.DB  0xB,0x2,0x1,0x7,0x8,0x6,0x8,0x7
	.DB  0xA,0x3,0x4,0xC,0x9,0x6,0xC,0xC
	.DB  0x9,0x5,0x8,0x5,0xC,0x9,0x2,0x1
	.DB  0x5,0x9,0x6,0xC,0xC,0x9,0x6,0xA
	.DB  0x6,0xE,0xA,0x4,0xA,0x6,0xB,0x6
	.DB  0xA,0x2,0x3,0x2,0x6,0xA,0x3,0x3
	.DB  0x3,0x3,0x3,0x6,0x1,0x6,0x10,0x4
	.DB  0xD,0x9,0x7,0x9,0x3,0x3,0x3,0x3
	.DB  0x3,0x5,0xB,0x7,0x9,0x3,0x1,0x5
	.DB  0xC,0xA,0x5,0x8,0x5,0x9,0x3,0x5
	.DB  0x9,0x0,0x3,0x7,0x8,0x3,0x6,0xC
	.DB  0xC,0x9,0x6,0xC,0x8,0x6,0x9,0x6
	.DB  0x8,0x6,0x9,0x1,0x6,0xB,0x1,0x6
	.DB  0xC,0x8,0x3,0x4,0xC,0xD,0xA,0x3
	.DB  0x6,0x9,0x6,0xC,0x9,0x5,0xA,0x1
	.DB  0x8,0x2,0x5,0xA,0x2,0x4,0x9,0x7
	.DB  0x9,0x2,0x5,0xC,0xC,0xC,0x9,0x6
	.DB  0x6,0x9,0x4,0x9,0x1,0x2,0x6,0xB
	.DB  0x6,0x9,0x4,0xC,0xC,0xA,0x2,0x7
	.DB  0x9,0x6,0xA,0x6,0xC,0x9,0x3,0x3
	.DB  0x1,0x2,0x6,0xA,0x2,0x1,0x3,0x7
	.DB  0xA,0x3,0x3,0x3,0x2,0x2,0x3,0x7
	.DB  0xA,0x3,0x3,0x3,0x7,0xA,0x3,0x7
	.DB  0x1,0x1,0x10,0x6,0x1,0x3,0x3,0x3
	.DB  0x5,0xD,0x9,0x5,0x9,0x5,0x9,0x5
	.DB  0x9,0x1,0x5,0xD,0xC,0x9,0x3,0x5
	.DB  0xC,0xC,0xC,0xA,0x6,0xC,0xC,0xA
	.DB  0x4,0xC,0x8,0x6,0xC,0xC,0x9,0x6
	.DB  0x8,0x4,0xA,0x1,0x5,0xA,0x6,0x9
	.DB  0x6,0xC,0xE,0xD,0xA,0x4,0xA,0x3
	.DB  0x6,0x8,0x1,0x6,0xC,0x9,0x3,0x6
	.DB  0x9,0x2,0x5,0xC,0xD,0xA,0x7,0xB
	.DB  0x5,0xC,0xA,0x5,0xC,0xC,0x9,0x3
	.DB  0x6,0x9,0x2,0x6,0xC,0x9,0x3,0x3
	.DB  0x2,0x6,0x9,0x4,0xC,0xC,0x8,0x5
	.DB  0x9,0x6,0x9,0x1,0x8,0x2,0x5,0x9
	.DB  0x5,0x9,0x4,0x8,0x6,0xC,0xC,0x8
	.DB  0x2,0x5,0x8,0x6,0xE,0xF,0xA,0x6
	.DB  0xA,0x6,0xA,0x2,0x7,0xA,0x6,0xA
	.DB  0x3,0x2,0x6,0xF
_sh:
	.DB  0x0,0x6E,0x2A,0x1E,0x1E,0x2A,0x6E,0x0
_mhome:
	.DB  0x0,0x7C,0x46,0x72,0x72,0x46,0x7C,0x0
__maze:
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80
	.DB  0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0xFF
	.DB  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
	.DB  0x81,0x81,0x81,0x81,0x81,0x81,0x81,0xFF
	.DB  0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xFF,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80
	.DB  0xFF,0x81,0x81,0x81,0x81,0x81,0x81,0x81
	.DB  0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0xFF
	.DB  0xFF,0x1,0x1,0x1,0x1,0x1,0x1,0xFF
	.DB  0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
	.DB  0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
_BOX_reference:
	.DB  0x2,0x3,0x2,0x0,0x0,0x7,0x2,0x0
	.DB  0x1,0x3,0x1,0x0,0x2,0x7,0x0,0x0
	.DB  0x2,0x3,0x1,0x0,0x3,0x6,0x0,0x0
	.DB  0x2,0x3,0x1,0x0,0x3,0x6,0x0,0x0
	.DB  0x1,0x3,0x2,0x0,0x6,0x3,0x0,0x0
	.DB  0x1,0x3,0x2,0x0,0x6,0x3,0x0,0x0
	.DB  0x3,0x1,0x1,0x0,0x0,0x1,0x7,0x0
	.DB  0x2,0x2,0x3,0x0,0x0,0x7,0x4,0x0
	.DB  0x1,0x1,0x3,0x0,0x0,0x4,0x7,0x0
	.DB  0x3,0x2,0x2,0x0,0x0,0x7,0x1,0x0
	.DB  0x3,0x3,0x0,0x0,0x3,0x3,0x0,0x0
	.DB  0x3,0x3,0x0,0x0,0x3,0x3,0x0,0x0
	.DB  0x2,0x2,0x2,0x2,0x0,0xF,0x0,0x0
	.DB  0x2,0x2,0x2,0x2,0x0,0xF,0x0,0x0
_message1:
	.DB  0x2A,0x2A,0x54,0x65,0x74,0x72,0x69,0x73
	.DB  0x2A,0x2A,0x20,0x20,0x20,0x20,0x47,0x61
	.DB  0x6D,0x65,0x21,0x0
_message2:
	.DB  0x50,0x72,0x65,0x73,0x20,0x45,0x6E,0x74
	.DB  0x65,0x72,0x0
_message3:
	.DB  0x20,0x54,0x6F,0x20,0x73,0x74,0x61,0x72
	.DB  0x74,0x0
_message4:
	.DB  0x47,0x61,0x6D,0x65,0x20,0x4F,0x76,0x65
	.DB  0x72,0x0
_message5:
	.DB  0x4C,0x69,0x6E,0x65,0x73,0x3A,0x0
_PIC1_BMP:
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0x1E,0xE,0xCE
	.DB  0xE,0x1E,0xFE,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0xFE,0x3E,0x9E
	.DB  0xE,0xE,0xFE,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0xFE,0x9E,0x8E
	.DB  0xCE,0xE,0x1E,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0xFE,0xDE,0xCE
	.DB  0x4E,0xE,0x9E,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0xFE,0x7E,0x1E
	.DB  0xE,0xE,0xFE,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0x3E,0xE,0x4E
	.DB  0x4E,0xCE,0xFE,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0x1E,0xE,0x4E
	.DB  0x4E,0xDE,0xFE,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0xFE,0x9E,0x9E
	.DB  0x9E,0x1E,0x9E,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x73
	.DB  0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F
	.DB  0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x7F,0x73,0x71
	.DB  0x70,0x72,0x73,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x7F,0x79,0x71
	.DB  0x73,0x70,0x78,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x78,0x78,0x79
	.DB  0x70,0x70,0x79,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x7A,0x72,0x72
	.DB  0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x72
	.DB  0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x63
	.DB  0x60,0x7C,0x7F,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0x9E,0xE,0x4E
	.DB  0xE,0x9E,0xFE,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xFE,0xFE,0xFE,0x1E,0xE
	.DB  0x4E,0xE,0x1E,0xFE,0xFE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0x9E,0xCE,0x6,0x6,0xFE,0xFE
	.DB  0xFE,0xE,0x6,0xE6,0x6,0xE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x3E,0x9E,0xE,0xE,0xFE
	.DB  0xFE,0xFE,0x3E,0x9E,0xE,0xE,0xFC,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0xFE,0x9E,0x8E,0xCE,0xE,0x1E,0xFC,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0xDE,0xCE,0x4E,0xE,0x9E,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0xFE,0x7E,0x1E,0xE,0xE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0x3E,0xE,0x4E,0x4E,0xCE,0xFE,0xFC,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x72
	.DB  0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x7F,0x7B,0x72
	.DB  0x72,0x70,0x78,0x7F,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x78,0x78,0x7F,0x7F
	.DB  0x7F,0x7C,0x78,0x79,0x78,0x7C,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x70,0x70,0x7F
	.DB  0x7F,0x7F,0x7F,0x7F,0x70,0x70,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x7F,0x73,0x71,0x70,0x72,0x73,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x79,0x71,0x73,0x70,0x78,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x78,0x78,0x79,0x70,0x70,0x79,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x7A,0x72,0x72,0x70,0x78,0x7F,0x3F,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0xFE,0x1E,0xE,0x4E,0x4E,0xDE,0xFC,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0xCE,0xCE,0x4E,0xE,0xCE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0x3E,0x9E,0xE,0xE,0xFE,0xFE
	.DB  0xFE,0x9E,0xE,0x4E,0xE,0x9E,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x3E,0x9E,0xE,0xE,0xFE
	.DB  0xFE,0x1E,0xE,0x4E,0xE,0x1E,0xFC,0x0
	.DB  0x0,0xFC,0x9E,0x8E,0xCE,0xE,0x1E,0xFE
	.DB  0x1E,0xE,0xCE,0xE,0x1E,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x9E,0x8E,0xCE,0xE,0x1E
	.DB  0xFE,0x3E,0x9E,0xE,0xE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0x9E,0x8E,0xCE,0xE,0x1E,0xFE
	.DB  0x9E,0x8E,0xCE,0xE,0x1E,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x9E,0x8E,0xCE,0xE,0x1E
	.DB  0xFE,0xDE,0xCE,0x4E,0xE,0x9E,0xFC,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x7F,0x71,0x70,0x7E,0x7F,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F
	.DB  0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x7F,0x7F,0x70,0x70,0x7F
	.DB  0x7F,0x7B,0x72,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F
	.DB  0x78,0x70,0x73,0x70,0x78,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73
	.DB  0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F
	.DB  0x73,0x71,0x70,0x72,0x73,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73
	.DB  0x7F,0x79,0x71,0x73,0x70,0x78,0x3F,0x0
	.DB  0x0,0xFC,0x9E,0x8E,0xCE,0xE,0x1E,0xFE
	.DB  0xFE,0x7E,0x1E,0xE,0xE,0xFE,0xFC,0x0
	.DB  0x0,0xFC,0x9E,0x8E,0xCE,0xE,0x1E,0xFE
	.DB  0xFE,0x3E,0xE,0x4E,0x4E,0xCE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x9E,0x8E,0xCE,0xE,0x1E
	.DB  0xFE,0x1E,0xE,0x4E,0x4E,0xDE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x9E,0x8E,0xCE,0xE,0x1E
	.DB  0xFE,0xCE,0xCE,0x4E,0xE,0xCE,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x9E,0x8E,0xCE,0xE,0x1E
	.DB  0xFE,0x9E,0xE,0x4E,0xE,0x9E,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0x9E,0x8E,0xCE,0xE,0x1E
	.DB  0xFE,0x1E,0xE,0x4E,0xE,0x1E,0xFC,0x0
	.DB  0x0,0xFC,0xFE,0xDE,0xCE,0x4E,0xE,0x9E
	.DB  0xFE,0x1E,0xE,0xCE,0xE,0x1E,0xFC,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F
	.DB  0x78,0x78,0x79,0x70,0x70,0x79,0x3F,0x0
	.DB  0x0,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F
	.DB  0x7F,0x7A,0x72,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73
	.DB  0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73
	.DB  0x7F,0x7F,0x71,0x70,0x7E,0x7F,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73
	.DB  0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73
	.DB  0x7F,0x7B,0x72,0x72,0x70,0x78,0x3F,0x0
	.DB  0x0,0x3F,0x7F,0x79,0x71,0x73,0x70,0x78
	.DB  0x7F,0x78,0x70,0x73,0x70,0x78,0x3F,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
_pblock:
	.DB  0x0,0x3C,0x76,0x6A,0x56,0x6A,0x56,0x6A
	.DB  0x56,0x6A,0x56,0x6A,0x56,0x6E,0x3C,0x0
_prackt:
	.DB  0x81,0xC3,0xE7,0xEF,0xF7,0xEF,0xF7,0xEF
	.DB  0xF7,0xEF,0xF7,0xEF,0xF7,0xE7,0xC3,0x81
	.DB  0x81,0xC2,0xE7,0xEE,0xF7,0xEE,0xF7,0xEE
	.DB  0xF7,0xEE,0xF7,0xEE,0xF7,0xE6,0xC3,0x81
_pball:
	.DB  0x3C,0x7E,0xFF,0xFF,0xDF,0xCF,0x7E,0x3C
_plevels:
	.DB  0xAA,0x55,0x0,0x0,0xAA,0xFF,0x0,0x0
	.DB  0xFF,0xC3,0x0,0x0,0x55,0xAA,0x55,0x0
	.DB  0xE7,0xC3,0xFF,0x0,0xFF,0x3C,0xFF,0x0
	.DB  0xFF,0x55,0xFF,0x0,0xFF,0xDB,0x92,0x0
	.DB  0xAA,0x55,0xAA,0xFF,0xFF,0xFF,0xFF,0xFF
_tbl10_G101:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G101:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;DATA STACK END MARKER INITIALIZATION
__DSTACK_END:
	.DB  'D','S','T','A','C','K','E','N','D',0

;HARDWARE STACK END MARKER INITIALIZATION
__HSTACK_END:
	.DB  'H','S','T','A','C','K','E','N','D',0

_0x19A:
	.DB  0x1F
_0x257:
	.DB  LOW(_maze_logo*2),HIGH(_maze_logo*2),LOW(_tetris_logo*2),HIGH(_tetris_logo*2),LOW(_puzzle_logo*2),HIGH(_puzzle_logo*2),LOW(_breakout_logo*2),HIGH(_breakout_logo*2)
_0x27E:
	.DB  0x64,0x0,0x0,0x0,0x0,0x0,0x0,0x0
_0x0:
	.DB  0x59,0x4F,0x55,0x20,0x57,0x4F,0x4E,0x20
	.DB  0x4C,0x65,0x76,0x65,0x6C,0x20,0x0,0x46
	.DB  0x6F,0x72,0x20,0x4E,0x65,0x77,0x20,0x47
	.DB  0x61,0x6D,0x65,0x20,0x50,0x72,0x65,0x73
	.DB  0x73,0x0,0x3C,0x2D,0x45,0x4E,0x54,0x45
	.DB  0x52,0x2D,0x3E,0x0,0x4F,0x72,0x20,0x45
	.DB  0x73,0x63,0x20,0x54,0x6F,0x20,0x45,0x78
	.DB  0x69,0x74,0x20,0x47,0x61,0x6D,0x65,0x2E
	.DB  0x0,0x25,0x69,0x0,0x54,0x6F,0x74,0x61
	.DB  0x6C,0x20,0x4D,0x6F,0x76,0x6D,0x65,0x6E
	.DB  0x74,0x20,0x69,0x73,0x20,0x0,0x59,0x6F
	.DB  0x75,0x20,0x57,0x6F,0x6E,0x20,0x54,0x68
	.DB  0x65,0x20,0x47,0x61,0x6D,0x65,0x21,0x0
	.DB  0x59,0x6F,0x75,0x20,0x57,0x6F,0x6E,0x21
	.DB  0x0,0x50,0x72,0x65,0x73,0x73,0x20,0x45
	.DB  0x6E,0x74,0x65,0x72,0x20,0x46,0x6F,0x72
	.DB  0x20,0x6C,0x65,0x76,0x65,0x6C,0x0,0x47
	.DB  0x61,0x6D,0x65,0x20,0x4F,0x76,0x65,0x72
	.DB  0x21,0x0,0x50,0x72,0x65,0x73,0x73,0x20
	.DB  0x45,0x53,0x43,0x20,0x54,0x6F,0x20,0x45
	.DB  0x78,0x69,0x74,0x2E,0x0
_0x204005F:
	.DB  0x1
_0x2040000:
	.DB  0x2D,0x4E,0x41,0x4E,0x0

__GLOBAL_INI_TBL:
	.DW  0x09
	.DW  0x60
	.DW  __DSTACK_END*2

	.DW  0x09
	.DW  0x2F6
	.DW  __HSTACK_END*2

	.DW  0x01
	.DW  _empty_id
	.DW  _0x19A*2

	.DW  0x08
	.DW  _menu_pic
	.DW  _0x257*2

	.DW  0x08
	.DW  0x07
	.DW  _0x27E*2

	.DW  0x01
	.DW  __seed_G102
	.DW  _0x204005F*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x800)
	LDI  R25,HIGH(0x800)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x85F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x85F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x260)
	LDI  R29,HIGH(0x260)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x260

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.04.4a Advanced
;Automatic Program Generator
; Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 2010/10/19
;Author  : Mohammad Mazarei
;Company : M2Prog
;Comments:
;
;
;Chip type               : ATmega32
;Program type            : Application
;AVR Core Clock frequency: 8.000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 512
;*****************************************************/
;
;//volatile unsigned char random_piece; //Used to select a piece "randomly" (but not really)
;#include <mega32.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <ks0108.h>
;#include <stdio.h>
;#include <stdlib.h>
;#include "GFX/bitmap.c"
;//
;
;flash char tetris_logo[]=
;{
;80,7,
;
;0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x81,0xC1,0x41,0x41,0x41,0x41,0x21,0x21,0x21,0x11,0x11,0x11,0x11,0x31,0x21,0x21,0x21,0x41,0x41,0x41,0x41,0xC1,0x81,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x00,0x10,0x00,0x7C,0x7C,0x7E,0x7F,0x78,0xF8,0xF8,0xF8,0xF8,0x00,0x00,0x40,0x40,0xE0,0xD0,0x30,0xF0,0x10,0x30,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x02,0x06,0x04,0x18,0x30,0x60,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x20,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x00,0x3A,0x45,0xAA,0x95,0x55,0x3F,0x01,0x00,0x80,0x41,0x7F,0xC0,0xF0,0xF0,0xF0,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x4F,0x7C,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x53,0x3A,0xBC,0x9C,0x5C,0x70,0xC0,0x80,0x00,0x00,0x00,0x00,0x80,0xC0,0x40,0x20,0x10,0x08,0x04,0x02,0x01,0x80,0xC0,0x60,0x18,0x06,0x07,0x1F,0x40,0x80,0x00,0x01,0x07,0x0F,0x3F,0x60,0xC0,0x80,0x00,0x00,0x00,0x80,0xC0,0x70,0x48,0x66,0x65,0xA4,0x44,0x4D,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x19,0x0E,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0xC0,0xE0,0xF8,0xFC,0x03,0xFD,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFF,0x0C,0xF8,0xC0,0x00,0x00,0x06,0x0C,0x03,0x06,0x0E,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x3B,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x08,0x38,0x58,0x98,0x30,0x30,0x30,0x64,0x64,0x64,0x30,0x10,0x0C,0x03,0xFF,0xFF,0xFF,0xFF,0x00,0x7B,0x7B,0x7B,0x7B,0x7B,0xFB,0xFB,0xFB,0x00,0x7F,0x7F,0x7F,0x7C,0x18,0xF8,0xD0,0xC0,0xC0,0x40,0x40,0x20,0xB0,0x50,0x38,0x0C,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x04,0x04,0x08,0x10,0x1F,0x3F,0x3F,0x00,0x6F,0x6F,0x6F,0x6F,0xE0,0xFF,0xFF,0xFF,0xFF,0xE0,0xEF,0x6F,0x6F,0x0F,0x6F,0x6F,0x2F,0x2F,0x20,0x0F,0x1F,0x0F,0x0F,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;};
;
;flash char agape_logo[]={
;128,8,
;0xFF,0xFF,0xFF,0xFF,0x0F,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,
;0xF9,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,0x38,0xDC,0xEC,0xE4,0x76,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x16,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x06,0x06,0xF6,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0xEE,0xDC,0x3C,0xF8,0xF0,0x00,0xFE,0xFE,0x06,0x06,0xF6,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x16,0x0E,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x1F,0x7F,0xFF,0xFF,0xFF,
;0xFF,0xFF,0xFF,0xFF,0xFE,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0x3F,0xC7,0xF8,0x7F,0x0F,0x01,0x03,0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0x00,0xFF,0xFF,0x01,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x0C,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0x3F,0xC7,0xF8,0x7F,0x0F,0x01,0x03,0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x9F,0xC7,0xF0,0xFF,0x3F,0x00,0xFF,0xFF,0x00,0x00,0xCF,0xCF,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xFF,0xFF,0xFF,
;0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x1C,0x00,0x00,0x00,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x00,0x00,0x0F,0x3F,0xF8,0xE7,0x9F,0xBE,0x70,0x60,0x60,0x60,0x60,0x60,0x60,0x7F,0x7F,0x7F,0x00,0xFF,0xFF,0x00,0x00,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x7F,0x7F,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,
;0xFF,0xFF,0xFF,0x03,0x01,0x00,0x00,0x00,0x00,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0xC3,0xC3,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x00,0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0F,0xFF,0xFF,0xFF,0xFF,
;0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0xC0,0xC0,0x40,0x20,0xA0,0x00,0xFF,0xFF,0x20,0x30,0x60,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xF8,0x78,0x78,0x78,0x38,0x38,0x98,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0x80,0x00,0x00,0xE0,0xF8,0xF8,0xF8,0xF8,0xF0,0xE0,0xF8,0xF8,0xF8,0x38,0x00,0x00,0xE0,0xF0,0xF8,0xF8,0xF8,0x78,0x78,0x38,0x80,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0x80,0x00,0x00,0xC0,0xF0,0xF8,0xF8,0xF8,0x38,0x00,0x00,0x00,0x80,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xB8,0xB8,0x38,0x18,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0xFF,
;0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x1F,0x1F,0x7F,0xFF,0xFF,0x71,0x6E,0xFE,0xFF,0xD7,0xD7,0xD7,0xD7,0xF6,0xFF,0xFE,0x6E,0x7F,0x3F,0x3F,0xBE,0x9E,0xD8,0xC0,0x00,0x00,0x00,0x00,0x1F,0x3F,0x7F,0x7F,0x7F,0x79,0x70,0x20,0x00,0x00,0x00,0x0F,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F,0x1F,0x03,0x78,0x7F,0x7F,0x3F,0x0F,0x1F,0x7F,0x7F,0x7F,0x3F,0x1F,0x03,0x70,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x3C,0x00,0x00,0x0F,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F,0x1F,0x03,0x78,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x00,0x78,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x77,0x77,0x33,0x00,0x00,0x00,0x00,0x0F,0x3F,0xFF,0xFF,0xFF,
;0x7F,0x7F,0xFF,0xFC,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFB,0xF2,0xFA,0xFB,0xFB,0xFD,0xFD,0xBD,0xBF,0xBE,0xBE,0x9E,0x9E,0x8F,0x8F,0x87,0x87,0x83,0x81,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xF0,0xF8,0xFF,0xFF
;
;}  ;
;
;
;flash char maze_logo[]=
;{
;80,7,
;0x51,0xA1,0x51,0xA1,0x51,0xA1,0x51,0xA1,0x51,0xE1,0x51,0xB1,0x51,0x01,0x01,0xA1,0x41,0x81,0x41,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x41,0xE1,0x51,0xA1,0x01,0x01,0x01,0xB9,0x55,0xF9,0x55,0xB9,0x55,0xA9,0x55,0xB9,0x55,0xA9,0xD5,0xA9,
;0x55,0x0A,0x55,0x22,0x55,0xAA,0x55,0x2B,0x55,0xAF,0x55,0xBB,0x55,0x00,0x00,0xBB,0x55,0xAF,0x55,0xBB,0x55,0xAA,0x54,0x20,0x50,0x00,0x00,0xA0,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x20,0x54,0x8A,0x55,0x2B,0x55,0xAE,0x55,0xBF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAB,0x55,0xAA,0x55,0xAA,0x55,0x8A,0x55,0xAA,
;0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0xAA,0x55,0xBB,0x01,0x00,0x00,0xBB,0x55,0xAA,0x55,0x22,0x55,0x00,0x55,0x02,0x55,0x00,0x00,0xAA,0x55,0xAA,0x55,0x00,0x00,0xB0,0x50,0x20,0x50,0x80,0x50,0x20,0x50,0xA0,0x50,0x20,0x50,0xA0,0x50,0x00,0x00,0xAA,0x55,0xBB,0x00,0x00,0x55,0x02,0x55,0x00,0x55,0x22,0x55,0xAA,0x55,0xBF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0x00,0x55,0xAA,
;0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0xAA,0x55,0xBB,0x50,0x00,0x00,0xBB,0x55,0xAA,0x55,0xA2,0x55,0x80,0x55,0x22,0x55,0x00,0x00,0x6A,0x55,0x2A,0x55,0x00,0x00,0x6A,0x55,0x22,0x55,0x20,0x55,0x22,0x55,0x22,0x55,0x22,0x55,0x2A,0x55,0x00,0x00,0x0A,0x15,0x3A,0x00,0x00,0x55,0x00,0x55,0x80,0x55,0x22,0x55,0xAA,0x55,0xFF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAA,0x55,0x8A,0x55,0x22,0x55,0x80,0x55,0xAA,
;0x55,0xA8,0x55,0xA2,0x55,0xAA,0x55,0xAA,0x55,0xEA,0x55,0xBB,0x55,0x00,0x00,0x2B,0x55,0xEE,0x55,0x3A,0x55,0x2A,0x15,0x02,0x05,0x02,0x00,0x00,0x00,0x00,0x15,0x2A,0x35,0x0E,0x35,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A,0x15,0x2A,0x14,0x28,0x10,0x20,0x00,0x00,0x01,0x02,0x05,0x0A,0x15,0x3A,0x55,0xEA,0x55,0xBB,0x00,0x00,0x00,0xBB,0x55,0xEA,0x55,0xAA,0x55,0xAA,0x55,0xA2,0x55,0xAA,0x55,0xAA,
;0x05,0x02,0x05,0x02,0x05,0x02,0x05,0x03,0x05,0x07,0x05,0x03,0x05,0x00,0x00,0x00,0x01,0x02,0x01,0x00,0x00,0x00,0x50,0x38,0x54,0x6A,0x54,0x7A,0x55,0x6A,0x55,0x2A,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x2A,0x55,0x6A,0x55,0x3A,0x55,0x6A,0x14,0x38,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x00,0x00,0x00,0x0B,0x05,0x0F,0x05,0x0B,0x05,0x0E,0x05,0x0A,0x05,0x0A,0x05,0x0A,
;0x54,0xEE,0x54,0xFA,0x54,0xFE,0x14,0x0A,0x00,0x00,0x00,0x80,0x40,0xA0,0x50,0xB8,0x54,0xAC,0x54,0xB8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x50,0xAC,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xB0,0x54,0xA8,0x54,0xB8,0x54,0xA8,0x54,0xB8,0x54,0xF8,0x50,0xA0,0x40,0x80,0x00,0x00,0x50,0xA8,0x70,0xF8,0xD0,0xF8,0x54,0xB8,0x54,0xE8,0x54,0xB8
;
;};
;
;flash char puzzle_logo[]={
;80,7,
;0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,0x77,0x03,0x57,0x0B,0x57,0x03,0x57,0x03,0x17,0xA5,0x15,0x19,0x19,0x01,0x01,0x01,0x71,0xB1,0xB1,0x21,0x71,0x21,0x61,0x21,0x61,0x81,0x41,0x81,0xC1,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;0x00,0x00,0xC0,0xA0,0x70,0x08,0x58,0x18,0x50,0x08,0x50,0x10,0x60,0x20,0x7D,0x0E,0x55,0x00,0x55,0x00,0x55,0x00,0x54,0x00,0x55,0x2B,0x5C,0x20,0x70,0x60,0x60,0xE0,0x78,0x3F,0x5F,0x00,0x51,0x00,0x44,0x00,0x15,0x02,0x45,0x00,0x15,0xA3,0xFD,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x20,0x60,0x20,
;0x00,0x00,0x01,0x06,0x15,0x10,0x10,0x00,0x11,0x18,0x0C,0xA8,0xFD,0x00,0x44,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x55,0x02,0x45,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0xF5,0xA8,0x7D,0x08,0x0C,0x0C,0x1D,0x18,0x34,0x20,0x71,0x0A,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xE0,0x51,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x55,0xFA,0xC1,0x80,0x80,0x00,0x00,0x00,0x07,0x8E,0xFC,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0xA8,0x9F,0x8B,0xD1,0x80,0xC4,0x80,0xD5,0x80,0x45,0x00,0x15,0x00,0x44,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x57,0x0E,0x5C,0x08,0x5C,0x0C,0x5C,0x08,0x5C,0xA8,0x50,0x00,0x00,0x00,0x00,0x80,0xC0,0x60,0x70,0x20,0x70,0x20,0x70,0x20,0x70,0x2F,0x7F,0x00,0x54,0x00,0x55,0x20,0x55,0x88,0x55,0x22,0x55,0x88,0x55,0xAB,0x55,0x8B,0x55,0xA3,0x55,0xA8,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xA0,0x7D,0x2E,0x5F,0x0A,0x40,0x00,0x55,0x20,0x7D,0x80,0x05,0x08,0x0C,0x08,0x31,0x20,0x55,0xA0,0xD5,0xC0,0x44,0x20,0x35,0x0A,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x0B,0x1F,0x28,0x71,0x20,0x34,0x00,0x15,0x08,0x1D,0x08,0xF9,0xF0,0x45,0x00,0x55,0x22,0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0x88,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0F,0x08,0x11,0x10,0x14,0x08,0x1D,0x08,0x0D,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x80,0xFF,0x2B,0x44,0x80,0xD5,0xC2,0xD5,0xE0,0x75,0x62,0x75,0x68,0x75,0xE2,0xF5,0x08,0x55,0x22,0xD5,0x88,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0xA8,0x44,0x02,0x17,0x02,0x57,0x02,0x51,0x03,0x55,0xA2,0xFE,0x0E,0x04,0x00,0x00,0x00,0x07,0x0C,0xFD,0xE0,0x54,0x00,0x51,0x00,0x55,0x00,0x51,0x20,0x55,0x8B,0x7F,0xBA,0xF7,0x83,0xD7,0x20,0x54,0x80,0x55,0x20,0x55,0x28,0x7F,0xC3,0xD5,0x80,0x55,0xA2,0x57,0x83,
;
;};
;
;flash char breakout_logo[]={
;80,7,
;0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0xC1,0xE1,0xF1,0xF1,0xF9,0xF9,0xF9,0xF9,0x79,0xF9,0xF9,0xF9,0xF9,0xF1,0xF1,0xE1,0xC1,0x81,0x01,0x01,0x01,0x01,0x01,0x01,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xFC,0xFF,0xFF,0xFF,0x1F,0x07,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x07,0x1F,0xFF,0xFF,0xFF,0xFC,0xC0,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0xC0,0x60,0x60,0x00,0x00,0x00,0x00,0x00,0x07,0x7F,0xFF,0xFF,0xFE,0xF8,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xF8,0xFE,0xFF,0xFF,0x7F,0x07,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0xC0,0x60,0x70,0x30,0x18,0x18,0x0C,0x0E,0x06,0x83,0x83,0xC1,0xE1,0x60,0x70,0x30,0x18,0x1C,0x88,0x80,0x80,0x00,0x00,0x00,0x03,0x07,0x0F,0x0F,0x1F,0x3F,0x3F,0x3E,0x3E,0x3C,0x3E,0x3E,0x3F,0x3F,0x1F,0x0F,0x0F,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x06,0x03,0x03,0x01,0x00,0x00,0x00,0x0C,0x0E,0x06,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xFF,0x07,0xFF,0xFF,0xFF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0xFF,0xFF,0x07,0xFF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xAF,0x57,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x3F,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3F,0x30,0x3F,0x3F,0x3F,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x3F,0x3F,0x30,0x3F,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3A,0x35,0x3F,0x3F,0x3F,0x1F,0x00,0x00,0x00,
;
;};
;
;flash char buttom[]={
;
;//next
;0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xFE,0xFE,0xFC,0xF8,0xF0,0xE0,0xC0,0x80,
;0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x3F,0x1F,0x0F,0x07,0x03,0x01,
;
;0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1E,0x02,0x04,0x08,0x10,0x20,0x40,0x80,
;0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x40,0x20,0x10,0x08,0x04,0x02,0x01,
;
;//Perv
;0x80,0xC0,0xE0,0xF0,0xF8,0xFC,0xFE,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
;0x01,0x03,0x07,0x0F,0x1F,0x3F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
;
;0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0xF0,
;0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0F
;
;} ;
;
;#define NEXT    0
;#define NEXT1   1
;#define PERV    2
;#define PERV1   3
;
;
;void show_pic(flash char *pic,char x, char y,char SPEED){
; 0000 001E void show_pic(flash char *pic,char x, char y,char SPEED){

	.CSEG
_show_pic:
;
;char  i,j,XS,YS;
;
;       XS=*pic;
	CALL __SAVELOCR4
;	*pic -> Y+7
;	x -> Y+6
;	y -> Y+5
;	SPEED -> Y+4
;	i -> R17
;	j -> R16
;	XS -> R19
;	YS -> R18
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	LPM  R19,Z
;       YS=*(pic+1);
	ADIW R30,1
	LPM  R18,Z
;    for(j=0;j<YS;j++){
	LDI  R16,LOW(0)
_0x4:
	CP   R16,R18
	BRSH _0x5
;        ks0108_gotoxy(0+x,j+y);;
	LDD  R30,Y+6
	ST   -Y,R30
	LDD  R30,Y+6
	ADD  R30,R16
	ST   -Y,R30
	CALL _ks0108_gotoxy
;    for(i=0;i<XS;i++)
	LDI  R17,LOW(0)
_0x7:
	CP   R17,R19
	BRSH _0x8
;        {
;        ks0108_Write(pic[j*XS+i+2]);
	MOV  R26,R16
	CLR  R27
	MOV  R30,R19
	LDI  R31,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;            }
	SUBI R17,-1
	RJMP _0x7
_0x8:
;            delay_ms(SPEED);
	LDD  R30,Y+4
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;  }
	SUBI R16,-1
	RJMP _0x4
_0x5:
;
;}
	CALL __LOADLOCR4
	ADIW R28,9
	RET
;
;void echange_right(flash char *pic,flash char *newpic, char x,char y){
_echange_right:
;
;char  i,j,XS,YS,c;
;
;       XS=*pic;
	CALL __SAVELOCR6
;	*pic -> Y+10
;	*newpic -> Y+8
;	x -> Y+7
;	y -> Y+6
;	i -> R17
;	j -> R16
;	XS -> R19
;	YS -> R18
;	c -> R21
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	LPM  R19,Z
;       YS=*(pic+1);
	ADIW R30,1
	LPM  R18,Z
;
;    for(c=0;c<XS+1;c+=10){
	LDI  R21,LOW(0)
_0xA:
	MOV  R30,R19
	LDI  R31,0
	ADIW R30,1
	MOV  R26,R21
	LDI  R27,0
	CP   R26,R30
	CPC  R27,R31
	BRLT PC+3
	JMP _0xB
;
;        for(i=0;i<XS-c;i++){
	LDI  R17,LOW(0)
_0xD:
	MOV  R26,R19
	CLR  R27
	MOV  R30,R21
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOV  R26,R17
	LDI  R27,0
	CP   R26,R30
	CPC  R27,R31
	BRGE _0xE
;            for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x10:
	CP   R16,R18
	BRSH _0x11
;            {
;            ks0108_gotoxy(x+i+c,j+y);
	MOV  R30,R17
	LDD  R26,Y+7
	ADD  R30,R26
	ADD  R30,R21
	ST   -Y,R30
	LDD  R30,Y+7
	ADD  R30,R16
	ST   -Y,R30
	CALL _ks0108_gotoxy
;            ks0108_Write(pic[j*XS+(i)+2]);
	MOV  R26,R16
	CLR  R27
	MOV  R30,R19
	LDI  R31,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;            }
	SUBI R16,-1
	RJMP _0x10
_0x11:
;
;        }
	SUBI R17,-1
	RJMP _0xD
_0xE:
;
;        for(i=0;i<c;i++){
	LDI  R17,LOW(0)
_0x13:
	CP   R17,R21
	BRSH _0x14
;            for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x16:
	CP   R16,R18
	BRSH _0x17
;            {
;            ks0108_gotoxy(x+i,j+y);;
	MOV  R30,R17
	LDD  R26,Y+7
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+7
	ADD  R30,R16
	ST   -Y,R30
	CALL _ks0108_gotoxy
;            ks0108_Write(newpic[j*XS+ (XS-c)+i +2]);
	MOV  R26,R16
	CLR  R27
	MOV  R30,R19
	LDI  R31,0
	CALL __MULW12
	MOVW R22,R30
	MOV  R26,R19
	CLR  R27
	MOV  R30,R21
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;           //ks0108_Write(0);
;            }
	SUBI R16,-1
	RJMP _0x16
_0x17:
;
;        }
	SUBI R17,-1
	RJMP _0x13
_0x14:
;
;    }
	SUBI R21,-LOW(10)
	RJMP _0xA
_0xB:
;}
	RJMP _0x20C001E
;
;
;void echange_left(flash char *pic,flash char *newpic, char x,char y){
_echange_left:
;
;char  i,j,XS,YS,c;
;
;       XS=*pic;
	CALL __SAVELOCR6
;	*pic -> Y+10
;	*newpic -> Y+8
;	x -> Y+7
;	y -> Y+6
;	i -> R17
;	j -> R16
;	XS -> R19
;	YS -> R18
;	c -> R21
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	LPM  R19,Z
;       YS=*(pic+1);
	ADIW R30,1
	LPM  R18,Z
;
;    for(c=0;c<XS+1;c+=10){
	LDI  R21,LOW(0)
_0x19:
	MOV  R30,R19
	LDI  R31,0
	ADIW R30,1
	MOV  R26,R21
	LDI  R27,0
	CP   R26,R30
	CPC  R27,R31
	BRLT PC+3
	JMP _0x1A
;        for(i=c;i<XS;i++){
	MOV  R17,R21
_0x1C:
	CP   R17,R19
	BRSH _0x1D
;            for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x1F:
	CP   R16,R18
	BRSH _0x20
;            {
;            ks0108_gotoxy((i-c)+x,j+y);
	MOV  R26,R17
	CLR  R27
	MOV  R30,R21
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDD  R26,Y+7
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+7
	ADD  R30,R16
	ST   -Y,R30
	CALL _ks0108_gotoxy
;            ks0108_Write(pic[j*XS+i+2]);
	MOV  R26,R16
	CLR  R27
	MOV  R30,R19
	LDI  R31,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;            }
	SUBI R16,-1
	RJMP _0x1F
_0x20:
;
;        }
	SUBI R17,-1
	RJMP _0x1C
_0x1D:
;
;        for(i=0;i<c;i++){
	LDI  R17,LOW(0)
_0x22:
	CP   R17,R21
	BRSH _0x23
;            for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x25:
	CP   R16,R18
	BRSH _0x26
;            {
;            ks0108_gotoxy(XS-(c-i)+x,j+y);
	MOV  R22,R19
	CLR  R23
	MOV  R26,R21
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOVW R26,R30
	MOVW R30,R22
	SUB  R30,R26
	SBC  R31,R27
	LDD  R26,Y+7
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+7
	ADD  R30,R16
	ST   -Y,R30
	CALL _ks0108_gotoxy
;            ks0108_Write(newpic[j*XS+i+2]);
	MOV  R26,R16
	CLR  R27
	MOV  R30,R19
	LDI  R31,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;            }
	SUBI R16,-1
	RJMP _0x25
_0x26:
;
;        }
	SUBI R17,-1
	RJMP _0x22
_0x23:
;
;    }
	SUBI R21,-LOW(10)
	RJMP _0x19
_0x1A:
;}
_0x20C001E:
	CALL __LOADLOCR6
	ADIW R28,12
	RET
;
;
;void show_but(char x,char y,char type){
_show_but:
;char i;
;
;ks0108_gotoxy(x,y);
	ST   -Y,R17
;	x -> Y+3
;	y -> Y+2
;	type -> Y+1
;	i -> R17
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _ks0108_gotoxy
;for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x28:
	CPI  R17,16
	BRSH _0x29
;    ks0108_Write(buttom[type*32+i]);
	LDD  R26,Y+1
	LDI  R30,LOW(32)
	MULS R30,R26
	MOVW R30,R0
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_buttom*2)
	SBCI R31,HIGH(-_buttom*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
	SUBI R17,-1
	RJMP _0x28
_0x29:
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	SUBI R30,-LOW(1)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x2B:
	CPI  R17,16
	BRSH _0x2C
;    ks0108_Write(buttom[type*32+16+i]);
	LDD  R26,Y+1
	LDI  R30,LOW(32)
	MULS R30,R26
	MOVW R30,R0
	ADIW R30,16
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_buttom*2)
	SBCI R31,HIGH(-_buttom*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
	SUBI R17,-1
	RJMP _0x2B
_0x2C:
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;}
	RJMP _0x20C001B
;#include "GFX/sound.h"
_sound_init:
	SBI  0x11,7
	RJMP _0x20C001D
_stop_sound:
	CLR  R6
	LDI  R30,LOW(0)
	OUT  0x25,R30
_0x20C001D:
	SBI  0x12,7
	RET
_play_sound:
;	*Sound -> Y+0
	__GETWRS 3,4,0
	RCALL _stop_sound
	LDI  R30,LOW(0)
	OUT  0x22,R30
	LDI  R30,LOW(30)
	OUT  0x25,R30
	LDI  R30,LOW(0)
	OUT  0x24,R30
	OUT  0x23,R30
	LDI  R30,LOW(1)
	MOV  R6,R30
	RJMP _0x20C001A
_paly_sound_key:
	SBIW R28,3
	CALL __SAVELOCR6
;	*song -> Y+9
;	Tone_temp -> R17
;	Tempo_temp -> R16
;	Duration_temp -> R19
;	*pSong_tmep -> R20,R21
;	Do_PLAY_temp -> R18
;	TCCR2_temp -> Y+8
;	TCNT2_tmep -> Y+7
;	OCR2_tmep -> Y+6
	LDS  R17,_Tone_G000
	LDS  R16,_Tempo_G000
	LDS  R19,_Duration_G000
	__MOVEWRR 20,21,3,4
	MOV  R18,R6
	IN   R30,0x25
	STD  Y+8,R30
	IN   R30,0x24
	STD  Y+7,R30
	IN   R30,0x23
	STD  Y+6,R30
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ _0x20C001C
	LDI  R30,LOW(0)
	OUT  0x25,R30
	CLR  R6
	__GETWRS 3,4,9
	STS  _Tone_G000,R30
	STS  _Duration_G000,R30
	LDI  R30,LOW(1)
	MOV  R6,R30
	LDI  R30,LOW(30)
	OUT  0x25,R30
_0x34:
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ _0x34
	STS  _Tone_G000,R17
	STS  _Tempo_G000,R16
	STS  _Duration_G000,R19
	__MOVEWRR 3,4,20,21
	MOV  R6,R18
	LDD  R30,Y+8
	OUT  0x25,R30
	LDD  R30,Y+7
	OUT  0x24,R30
	LDD  R30,Y+6
	OUT  0x23,R30
_0x20C001C:
	CALL __LOADLOCR6
	ADIW R28,11
	RET
_Play_Tune:
	ST   -Y,R17
	ST   -Y,R16
;	temp_tone -> R17
;	loop -> R16
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ PC+3
	JMP _0x37
	LDS  R30,_Tone_G000
	CPI  R30,0
	BRNE _0x38
	LDI  R30,LOW(0)
	STS  _Duration_G000,R30
	__GETW1R 3,4
	ADIW R30,0
	LPM  R0,Z
	STS  _Tempo_G000,R0
	LDI  R30,LOW(1)
	STS  _Tone_G000,R30
_0x38:
	LDS  R30,_Tempo_G000
	CPI  R30,0
	BREQ PC+3
	JMP _0x39
	LDS  R30,_Duration_G000
	CPI  R30,0
	BREQ _0x3A
	SUBI R30,LOW(1)
	STS  _Duration_G000,R30
	RJMP _0x3B
_0x3A:
	LDS  R30,_Tone_G000
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R30,Z
	CPI  R30,0
	BREQ _0x3C
	LDS  R30,_Tone_G000
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R30,Z
	LDI  R31,0
	LDI  R26,LOW(32)
	LDI  R27,HIGH(32)
	CALL __DIVW21
	STS  _Duration_G000,R30
	LDS  R30,_Tone_G000
	SUBI R30,-LOW(1)
	STS  _Tone_G000,R30
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R17,Z
	MOV  R26,R17
	LDI  R30,LOW(1)
	CALL __EQB12
	MOV  R0,R30
	OR   R30,R0
	BREQ _0x3D
	LDI  R30,LOW(0)
	RJMP _0x275
_0x3D:
	LDI  R30,LOW(30)
_0x275:
	OUT  0x25,R30
	LDI  R30,LOW(0)
	OUT  0x24,R30
	OUT  0x23,R17
	LDS  R30,_Tone_G000
	SUBI R30,-LOW(1)
	STS  _Tone_G000,R30
	RJMP _0x3F
_0x3C:
	LDS  R30,_Tone_G000
	SUBI R30,-LOW(1)
	STS  _Tone_G000,R30
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R16,Z
	CPI  R16,0
	BREQ _0x40
	LDI  R30,LOW(1)
	STS  _Tone_G000,R30
	RJMP _0x41
_0x40:
	CLR  R6
	LDI  R30,LOW(0)
	OUT  0x25,R30
	SBI  0x12,7
_0x41:
_0x3F:
_0x3B:
	__GETW1R 3,4
	ADIW R30,0
	LPM  R0,Z
	STS  _Tempo_G000,R0
	RJMP _0x44
_0x39:
	LDS  R30,_Tempo_G000
	SUBI R30,LOW(1)
	STS  _Tempo_G000,R30
_0x44:
_0x37:
	RJMP _0x20C0019
;#include "GFX/wave.h"
;#include "GFX/font.h"
;#include "GFX/GFX.c"
;//
;void put_char(char x,char y,char ch){
; 0000 0022 void put_char(char x,char y,char ch){
_put_char:
;char i;
;
;ks0108_gotoxy(x,y);
	ST   -Y,R17
;	x -> Y+3
;	y -> Y+2
;	ch -> Y+1
;	i -> R17
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _ks0108_gotoxy
;for(i=0;i<5;i++)
	LDI  R17,LOW(0)
_0x46:
	CPI  R17,5
	BRSH _0x47
;     ks0108_Write(font[(ch-' ')*5+i]);
	LDD  R30,Y+1
	LDI  R31,0
	SBIW R30,32
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_font*2)
	SBCI R31,HIGH(-_font*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
	SUBI R17,-1
	RJMP _0x46
_0x47:
_0x20C001B:
	LDD  R17,Y+0
	ADIW R28,4
	RET
;
;
;void lputs(char x,char y, char *st){
_lputs:
;char i=0;
;
;while(*st!=0){
	ST   -Y,R17
;	x -> Y+4
;	y -> Y+3
;	*st -> Y+1
;	i -> R17
	LDI  R17,0
_0x48:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X
	CPI  R30,0
	BREQ _0x4A
;    put_char(x+i*6,y,*st);
	LDI  R26,LOW(6)
	MULS R17,R26
	MOVW R30,R0
	LDD  R26,Y+4
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	LDD  R26,Y+3
	LDD  R27,Y+3+1
	LD   R30,X
	ST   -Y,R30
	RCALL _put_char
;    i++;
	SUBI R17,-1
;    st++;
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
;    }
	RJMP _0x48
_0x4A:
;}
	LDD  R17,Y+0
	RJMP _0x20C0014
;
;void lputsf(char x,char y,flash char *st){
_lputsf:
;
;char i=0;
;
;while(*st!=0){
	ST   -Y,R17
;	x -> Y+4
;	y -> Y+3
;	*st -> Y+1
;	i -> R17
	LDI  R17,0
_0x4B:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	LPM  R30,Z
	CPI  R30,0
	BREQ _0x4D
;    put_char(x+i*6,y,*st);
	LDI  R26,LOW(6)
	MULS R17,R26
	MOVW R30,R0
	LDD  R26,Y+4
	ADD  R30,R26
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	LPM  R30,Z
	ST   -Y,R30
	RCALL _put_char
;    i++;
	SUBI R17,-1
;    st++;
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
;    }
	RJMP _0x4B
_0x4D:
;
;}
	LDD  R17,Y+0
	RJMP _0x20C0014
;
;
;void GLCD_string_sideways(unsigned char X, unsigned char Y, flash char * str,unsigned char array_length)
;{
_GLCD_string_sideways:
;        //TODO: Move this to the GLCD library
;
;        //Loop through each char in array
;        unsigned char temp_array[7]; //Array to store character data
;        unsigned char tot_cols = (array_length-1) * 6;
;        unsigned char temp_index = 0; //Will track each column (5 per char + space) in array
;        unsigned char current_char; //Keeps track of what char to draw right now
;        unsigned char char_column_info; //Stores data read in from font5x8.h
;        unsigned char i,read_column,j;
;        while (temp_index <= tot_cols)
	SBIW R28,8
	CALL __SAVELOCR6
;	X -> Y+18
;	Y -> Y+17
;	*str -> Y+15
;	array_length -> Y+14
;	temp_array -> Y+7
;	tot_cols -> R17
;	temp_index -> R16
;	current_char -> R19
;	char_column_info -> R18
;	i -> R21
;	read_column -> R20
;	j -> Y+6
	LDD  R30,Y+14
	LDI  R31,0
	SBIW R30,1
	LDI  R26,LOW(6)
	MULS R30,R26
	MOVW R30,R0
	MOV  R17,R30
	LDI  R16,0
_0x4E:
	CP   R17,R16
	BRSH PC+3
	JMP _0x50
;        {
;          //Write each column of all 7 chars in temp_array[] including spaces
;          for (i=0; i<8; i++)
	LDI  R21,LOW(0)
_0x52:
	CPI  R21,8
	BRLO PC+3
	JMP _0x53
;          {
;                  read_column = temp_index % 6;
	MOV  R26,R16
	CLR  R27
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __MODW21
	MOV  R20,R30
;                  if (read_column) //We should be writing char data to a column
	CPI  R20,0
	BRNE PC+3
	JMP _0x54
;                  {
;                          --read_column;
	SUBI R20,LOW(1)
;                          if (temp_index > tot_cols) current_char = ' '; //Fill with spaces when we run out of chars
	CP   R17,R16
	BRSH _0x55
	LDI  R19,LOW(32)
;                          else
	RJMP _0x56
_0x55:
;                                current_char = *(str+(temp_index/6)); //Get which char we are currently writing
	MOV  R26,R16
	LDI  R27,0
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __DIVW21
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;                                current_char -= ' '; //Adjust to match the font5x8.h array
_0x56:
	MOV  R30,R19
	LDI  R31,0
	SBIW R30,32
	MOV  R19,R30
;
;                          char_column_info = *(font + (5 * current_char) + read_column); //Read column in from font5x8.h
	LDI  R26,LOW(5)
	MULS R19,R26
	MOVW R30,R0
	SUBI R30,LOW(-_font*2)
	SBCI R31,HIGH(-_font*2)
	MOVW R26,R30
	MOV  R30,R20
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R18,Z
;                         // ks0108_gotoxy(10,0);
;                         // ks0108_Write(char_column_info);
;                          //while(1) { ;; }
;                          for (j=0; j<7; j++)
	LDI  R30,LOW(0)
	STD  Y+6,R30
_0x58:
	LDD  R26,Y+6
	CPI  R26,LOW(0x7)
	BRSH _0x59
;                          {
;                                  if (char_column_info & (1<<(6-j))) temp_array[j] |= 1<<i;
	LDD  R30,Y+6
	LDI  R31,0
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R18
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x5A
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R21
	LDI  R26,LOW(1)
	CALL __LSLB12
	OR   R30,R1
	RJMP _0x276
;                                  else temp_array[j] &= ~(1<<i);
_0x5A:
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R21
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R1
_0x276:
	MOVW R26,R22
	ST   X,R30
;                          }
	LDD  R30,Y+6
	SUBI R30,-LOW(1)
	STD  Y+6,R30
	RJMP _0x58
_0x59:
;                  }
;                  else //We are currently writing a space after a char to a column
	RJMP _0x5C
_0x54:
;		  {
;			  for (j=0; j<7; j++)
	LDI  R30,LOW(0)
	STD  Y+6,R30
_0x5E:
	LDD  R26,Y+6
	CPI  R26,LOW(0x7)
	BRSH _0x5F
;			  {
;				  temp_array[j] &= ~(1<<i);
	LDD  R30,Y+6
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R21
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R1
	MOVW R26,R22
	ST   X,R30
;			  }
	LDD  R30,Y+6
	SUBI R30,-LOW(1)
	STD  Y+6,R30
	RJMP _0x5E
_0x5F:
;		  }
_0x5C:
;		  ++temp_index; //We have written a column, increment the index
	SUBI R16,-LOW(1)
;
;
;	  }
	SUBI R21,-1
	RJMP _0x52
_0x53:
;	  //Now display the data we have just stored
;	  ks0108_gotoxy(Y,X);
	LDD  R30,Y+17
	ST   -Y,R30
	LDD  R30,Y+19
	ST   -Y,R30
	CALL _ks0108_gotoxy
;	  if (++X > 7) //Take care of line wrapping
	LDD  R26,Y+18
	SUBI R26,-LOW(1)
	STD  Y+18,R26
	CPI  R26,LOW(0x8)
	BRLO _0x60
;	  {
;		  X = 0;
	LDI  R30,LOW(0)
	STD  Y+18,R30
;		  Y -= 8;
	LDD  R30,Y+17
	LDI  R31,0
	SBIW R30,8
	STD  Y+17,R30
;	  }
;	  for (i=0; i<7; i++) ks0108_Write(temp_array[i]);
_0x60:
	LDI  R21,LOW(0)
_0x62:
	CPI  R21,7
	BRSH _0x63
	MOV  R30,R21
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,7
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	ST   -Y,R30
	CALL _ks0108_Write
	SUBI R21,-1
	RJMP _0x62
_0x63:
	RJMP _0x4E
_0x50:
;}
	CALL __LOADLOCR6
	ADIW R28,19
	RET
;
;
;#include "key.c"
;// KEY
;//Debounce definitions
;#define KEY_DDR     DDRD
;#define KEY_PIN     PIND
;#define KEY_PORT     PORTD
;
;#define BTN_UP      4
;#define BTN_DN      3
;#define BTN_LT      2
;#define BTN_RT      5
;#define BTN_EN      6
;#define BTN_MD      0
;#define BTN_ES      1
;
;#define KEY_MSK     (1<<BTN_UP | 1<<BTN_DN | 1<<BTN_LT | 1<<BTN_RT | 1<<BTN_EN | 1<<BTN_MD | 1<<BTN_ES)
;volatile unsigned char key_press;
;//Debounce
;//unsigned char debounce_cnt = 0;
;unsigned char key_state;
;
;unsigned char get_key_press(unsigned char key_mask)
; 0000 0023 {
_get_key_press:
;  #asm("cli")
;	key_mask -> Y+0
	cli
;  key_mask &= key_press;                        // read key(s)
	LDS  R30,_key_press
	LD   R26,Y
	AND  R30,R26
	ST   Y,R30
;  key_press ^= key_mask;                        // clear key(s)
	LDS  R26,_key_press
	EOR  R30,R26
	STS  _key_press,R30
;  #asm("sei")
	sei
;  return key_mask;
	LD   R30,Y
	RJMP _0x20C0017
;}
;
;void Key_init(void){
_Key_init:
;KEY_DDR=~KEY_MSK;
	LDI  R30,LOW(128)
	OUT  0x11,R30
;KEY_PORT=KEY_MSK;
	LDI  R30,LOW(127)
	OUT  0x12,R30
;
;}
	RET
;#include "timer.c"
;
;
;// Timer 0 output compare interrupt service routine
;static char timer_down=0;
;static char drop_timer_flag=0;
;
;//this method beham parts in partsLoc[]
;flash char rnd_table[256] = {
;4,173,100,101,85,149,200,67,41,61,8,232,179,221,127,90,223,
;172,0,216,233,183,243,122,237,226,6,240,140,174,175,211,157,
;19,204,180,44,203,96,181,35,135,208,36,159,39,178,89,112,
;215,106,195,75,185,119,114,142,26,20,22,201,177,164,34,197,
;48,222,51,130,16,120,199,202,109,13,68,10,137,92,1,189,
;246,160,93,150,147,47,154,60,156,217,253,134,205,88,64,184,
;129,59,126,110,27,124,54,42,32,66,207,143,115,70,235,91,
;99,190,252,72,169,117,46,94,3,187,210,128,83,162,52,82,
;77,214,248,37,192,111,186,18,23,196,241,229,148,176,107,7,
;79,105,167,250,30,62,144,65,71,97,17,11,24,102,103,238,
;230,139,55,163,155,209,254,56,25,95,236,191,213,123,78,152,
;228,73,193,14,225,125,69,104,239,220,198,212,165,251,245,166,
;161,21,206,247,249,158,98,219,40,170,58,57,151,244,168,188,
;86,45,218,133,63,136,81,224,146,118,53,227,87,76,74,131,
;132,28,141,33,49,50,194,138,182,121,231,15,116,108,43,234,
;145,113,29,38,242,2,5,31,171,80,12,84,153,9 };
;unsigned char rnd_index = 0;
;unsigned char overflow_t0 = 100;
;char rnd(unsigned char min , unsigned char max)
; 0000 0024 {
_rnd:
;	rnd_index++;
;	min -> Y+1
;	max -> Y+0
	INC  R8
;    if(min == max)
	LD   R30,Y
	LDD  R26,Y+1
	CP   R30,R26
	BRNE _0x64
;		return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C001A
;	return (*(rnd_table+rnd_index)%(max-min)) + min;
_0x64:
	MOV  R30,R8
	LDI  R31,0
	SUBI R30,LOW(-_rnd_table*2)
	SBCI R31,HIGH(-_rnd_table*2)
	LPM  R22,Z
	CLR  R23
	LD   R26,Y
	CLR  R27
	LDD  R30,Y+1
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOVW R26,R22
	CALL __MODW21
	LDD  R26,Y+1
	ADD  R30,R26
	RJMP _0x20C001A
;}
;
;interrupt [TIM0_COMP] void timer0_comp_isr(void)
;{
_timer0_comp_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
;      static unsigned char ct0, ct1;
;  unsigned char i;
;  i = key_state ^ ~KEY_PIN;    // key changed ?
	ST   -Y,R17
;	i -> R17
	IN   R30,0x10
	COM  R30
	EOR  R30,R5
	MOV  R17,R30
;  ct0 = ~( ct0 & i );          // reset or count ct0
	MOV  R30,R17
	LDS  R26,_ct0_S0000010000
	AND  R30,R26
	COM  R30
	STS  _ct0_S0000010000,R30
;  ct1 = ct0 ^ (ct1 & i);       // reset or count ct1
	MOV  R30,R17
	LDS  R26,_ct1_S0000010000
	AND  R30,R26
	LDS  R26,_ct0_S0000010000
	EOR  R30,R26
	STS  _ct1_S0000010000,R30
;  i &= ct0 & ct1;              // count until roll over ?
	AND  R30,R26
	AND  R17,R30
;  key_state ^= i;              // then toggle debounced state
	EOR  R5,R17
;  key_press |= key_state & i;  // 0->1: key press detect
	MOV  R30,R17
	AND  R30,R5
	LDS  R26,_key_press
	OR   R30,R26
	STS  _key_press,R30
;  //if (++random_piece > 6) random_piece = 0;     // For make Random on ttris Game
;
;  if (++timer_down > overflow_t0)
	LDS  R26,_timer_down_G000
	SUBI R26,-LOW(1)
	STS  _timer_down_G000,R26
	CP   R7,R26
	BRSH _0x65
;  {
;   timer_down=0;
	LDI  R30,LOW(0)
	STS  _timer_down_G000,R30
;   drop_timer_flag = 1;
	LDI  R30,LOW(1)
	STS  _drop_timer_flag_G000,R30
;  }
;    // Call Evry 10ms in 8MHZ CPU
; Play_Tune();
_0x65:
	RCALL _Play_Tune
;}
	LD   R17,Y+
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;
;void init_timer0(){
_init_timer0:
;// Timer/Counter 0 initialization
;// Clock source: System Clock
;// Clock value: 7.813 kHz
;// Mode: CTC top=OCR0
;// OC0 output: Disconnected
;TCCR0=0x0D;
	LDI  R30,LOW(13)
	OUT  0x33,R30
;TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
;OCR0=0x4E;
	LDI  R30,LOW(78)
	OUT  0x3C,R30
;
;TIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x39,R30
;
;
;}
	RET
;#include "softpwm.c"
;#define SPWM    PORTC.0
;#define SPWMD   DDRC.0
;
;
;// Timer1 overflow interrupt service routine
;interrupt [TIM1_OVF] void timer1_ovf_isr(void)
; 0000 0025 {
_timer1_ovf_isr:
;SPWM=0;
	CBI  0x15,0
;}
	RETI
;
;// Timer1 output compare A interrupt service routine
;interrupt [TIM1_COMPA] void timer1_compa_isr(void)
;{
_timer1_compa_isr:
;SPWM=1;
	SBI  0x15,0
;}
	RETI
;
;void load_pwm(unsigned int pw){
_load_pwm:
;OCR1AH=pw>>8;
;	pw -> Y+0
	LDD  R30,Y+1
	ANDI R31,HIGH(0x0)
	OUT  0x2B,R30
;OCR1AL=pw & 0xFF;
	LD   R30,Y
	OUT  0x2A,R30
;}
_0x20C001A:
	ADIW R28,2
	RET
;void wait_us(unsigned int val){
_wait_us:
; int i;
; for(i=0;i<val-5;i++)
	ST   -Y,R17
	ST   -Y,R16
;	val -> Y+2
;	i -> R16,R17
	__GETWRN 16,17,0
_0x6B:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SBIW R30,5
	CP   R16,R30
	CPC  R17,R31
	BRSH _0x6C
;        delay_us(1);
	__DELAY_USB 3
	__ADDWRN 16,17,1
	RJMP _0x6B
_0x6C:
	RJMP _0x20C0013
;
;void light_on(unsigned int d_us){
_light_on:
;unsigned int i;
;for(i=0;i<0xFFFF-50;i+=50){
	ST   -Y,R17
	ST   -Y,R16
;	d_us -> Y+2
;	i -> R16,R17
	__GETWRN 16,17,0
_0x6E:
	__CPWRN 16,17,-51
	BRSH _0x6F
; load_pwm(i);
	ST   -Y,R17
	ST   -Y,R16
	RCALL _load_pwm
; wait_us((unsigned int)d_us);
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _wait_us
;}
	__ADDWRN 16,17,50
	RJMP _0x6E
_0x6F:
;load_pwm(0xFFFE);
	LDI  R30,LOW(65534)
	LDI  R31,HIGH(65534)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _load_pwm
;}
	RJMP _0x20C0013
;
;void light_off(unsigned int d_us){
_light_off:
;unsigned int i;
;for(i=0;i<0xFFFF-50;i+=50){
	ST   -Y,R17
	ST   -Y,R16
;	d_us -> Y+2
;	i -> R16,R17
	__GETWRN 16,17,0
_0x71:
	__CPWRN 16,17,-51
	BRSH _0x72
; load_pwm(0xFFFF-50-i);
	LDI  R30,LOW(65485)
	LDI  R31,HIGH(65485)
	SUB  R30,R16
	SBC  R31,R17
	ST   -Y,R31
	ST   -Y,R30
	RCALL _load_pwm
; wait_us((unsigned int)d_us);
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _wait_us
;}
	__ADDWRN 16,17,50
	RJMP _0x71
_0x72:
;load_pwm(20);
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _load_pwm
;}
	RJMP _0x20C0013
;
;void light_effect1(unsigned int d_us){
;light_off(d_us);
;	d_us -> Y+0
;light_on(d_us);
;}
;
;void init_spwm(void){
_init_spwm:
;
;// Timer/Counter 1 initialization
;// Clock source: System Clock
;// Clock value: 8000.000 kHz
;// Mode: Normal top=FFFFh
;// OC1A output: Discon.
;// OC1B output: Discon.
;// Noise Canceler: Off
;// Input Capture on Falling Edge
;// Timer1 Overflow Interrupt: On
;// Input Capture Interrupt: Off
;// Compare A Match Interrupt: On
;// Compare B Match Interrupt: Off
;TCCR1A=0x00;
	LDI  R30,LOW(0)
	OUT  0x2F,R30
;TCCR1B=0x01;
	LDI  R30,LOW(1)
	OUT  0x2E,R30
;TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
;TCNT1L=0x01;
	LDI  R30,LOW(1)
	OUT  0x2C,R30
;ICR1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x27,R30
;ICR1L=0x00;
	OUT  0x26,R30
;OCR1AH=0x00;
	OUT  0x2B,R30
;OCR1AL=0x01;
	LDI  R30,LOW(1)
	OUT  0x2A,R30
;OCR1BH=0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
;OCR1BL=0x00;
	OUT  0x28,R30
;// Timer(s)/Counter(s) Interrupt(s) initialization
;TIMSK |=0x14;
	IN   R30,0x39
	ORI  R30,LOW(0x14)
	OUT  0x39,R30
;SPWMD=1;
	SBI  0x14,0
;SPWM=1;
	SBI  0x15,0
;load_pwm(1);
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _load_pwm
;}
	RET
;#include "game's/maze.c"
;//
;#define xy(x,y)   x+y*16
;#define    UP   1
;#define    DOWN   2
;#define    RIGHT    4
;#define    LEFT    8
;
;struct MAZE_GMAE
;{
;
; char p_x;
; char p_y;
; char s_x;
; char s_y;
; char e_x;
; char e_y;
; int move;
; char level;
; char hide;
; flash char *map;
;}maze;
;
;#define level_len   132
;flash char maze_levels[660]={
;0x02,0x01,
;0x10,0x08,
;0x0D,0x08,0x03,0x03,0x01,0x05,0x09,0x05,0x09,0x03,0x01,0x07,0x0B,0x01,0x03,0x05,
;0x0A,0x04,0x09,0x01,0x02,0x04,0x0C,0x0A,0x04,0x09,0x02,0x03,0x05,0x0A,0x05,0x0C,
;0x0D,0x0C,0x0C,0x0C,0x09,0x06,0x0A,0x05,0x0A,0x06,0x09,0x05,0x0C,0x09,0x06,0x0E,
;0x0C,0x0A,0x02,0x06,0x0A,0x01,0x05,0x0A,0x03,0x05,0x0C,0x0A,0x02,0x06,0x09,0x05,
;0x08,0x07,0x09,0x03,0x01,0x06,0x0A,0x03,0x05,0x0C,0x0C,0x09,0x03,0x05,0x0C,0x0C,
;0x08,0x05,0x0A,0x03,0x02,0x03,0x05,0x09,0x06,0x0C,0x0A,0x02,0x05,0x0C,0x0C,0x0C,
;0x08,0x04,0x09,0x03,0x05,0x09,0x04,0x0A,0x01,0x00,0x07,0x0D,0x0A,0x02,0x06,0x0C,
;0x0E,0x0A,0x02,0x03,0x02,0x06,0x0A,0x07,0x0E,0x0A,0x03,0x06,0x0F,0x0B,0x07,0x0C,
;
;0x08,0x01,
;0x08,0x08,
;0x0D,0x09,0x01,0x03,0x01,0x03,0x05,0x0A,0x03,0x05,0x0D,0x09,0x03,0x03,0x03,0x05,
;0x0C,0x0A,0x02,0x05,0x0A,0x05,0x0A,0x01,0x07,0x0A,0x04,0x0A,0x03,0x05,0x09,0x06,
;0x0C,0x09,0x01,0x00,0x03,0x06,0x09,0x06,0x09,0x03,0x02,0x01,0x03,0x04,0x08,0x07,
;0x0A,0x04,0x0C,0x0A,0x01,0x05,0x08,0x05,0x0A,0x03,0x05,0x08,0x05,0x0C,0x0A,0x05,
;0x09,0x06,0x0A,0x03,0x06,0x0A,0x06,0x08,0x03,0x07,0x0C,0x0E,0x0A,0x04,0x09,0x04,
;0x0C,0x09,0x03,0x01,0x03,0x03,0x05,0x0A,0x05,0x09,0x04,0x09,0x03,0x06,0x0C,0x0C,
;0x08,0x06,0x0D,0x0A,0x03,0x05,0x0A,0x05,0x0A,0x06,0x08,0x02,0x03,0x01,0x06,0x0C,
;0x0E,0x0B,0x06,0x0F,0x0B,0x02,0x07,0x0C,0x0B,0x07,0x0A,0x03,0x03,0x02,0x07,0x0E,
;
;0x01,0x02,
;0x010,0x04,
;0x09,0x05,0x09,0x03,0x01,0x05,0x09,0x05,0x0B,0x05,0x0D,0x09,0x05,0x0D,0x0D,0x0D,
;0x06,0x0A,0x04,0x09,0x02,0x04,0x0C,0x0A,0x01,0x00,0x06,0x0C,0x0C,0x0C,0x0A,0x06,
;0x09,0x05,0x0C,0x0A,0x01,0x06,0x08,0x05,0x0A,0x02,0x05,0x0C,0x0C,0x08,0x03,0x05,
;0x08,0x04,0x0E,0x09,0x00,0x05,0x0C,0x0C,0x09,0x03,0x04,0x0C,0x0E,0x08,0x03,0x02,
;0x0C,0x0C,0x09,0x06,0x0C,0x0A,0x04,0x0C,0x0A,0x05,0x0C,0x0C,0x0B,0x02,0x01,0x07,
;0x08,0x06,0x08,0x07,0x0A,0x03,0x04,0x0C,0x09,0x06,0x0C,0x0C,0x09,0x05,0x08,0x05,
;0x0C,0x09,0x02,0x01,0x05,0x09,0x06,0x0C,0x0C,0x09,0x06,0x0A,0x06,0x0E,0x0A,0x04,
;0x0A,0x06,0x0B,0x06,0x0A,0x02,0x03,0x02,0x06,0x0A,0x03,0x03,0x03,0x03,0x03,0x06,
;
;0x01,0x06,
;0x010,0x04,
;0x0D,0x09,0x07,0x09,0x03,0x03,0x03,0x03,0x03,0x05,0x0B,0x07,0x09,0x03,0x01,0x05,
;0x0C,0x0A,0x05,0x08,0x05,0x09,0x03,0x05,0x09,0x00,0x03,0x07,0x08,0x03,0x06,0x0C,
;0x0C,0x09,0x06,0x0C,0x08,0x06,0x09,0x06,0x08,0x06,0x09,0x01,0x06,0x0B,0x01,0x06,
;0x0C,0x08,0x03,0x04,0x0C,0x0D,0x0A,0x03,0x06,0x09,0x06,0x0C,0x09,0x05,0x0A,0x01,
;0x08,0x02,0x05,0x0A,0x02,0x04,0x09,0x07,0x09,0x02,0x05,0x0C,0x0C,0x0C,0x09,0x06,
;0x06,0x09,0x04,0x09,0x01,0x02,0x06,0x0B,0x06,0x09,0x04,0x0C,0x0C,0x0A,0x02,0x07,
;0x09,0x06,0x0A,0x06,0x0C,0x09,0x03,0x03,0x01,0x02,0x06,0x0A,0x02,0x01,0x03,0x07,
;0x0A,0x03,0x03,0x03,0x02,0x02,0x03,0x07,0x0A,0x03,0x03,0x03,0x07,0x0A,0x03,0x07,
;
;0x01,0x01,
;0x010,0x06,
;0x01,0x03,0x03,0x03,0x05,0x0D,0x09,0x05,0x09,0x05,0x09,0x05,0x09,0x01,0x05,0x0D,
;0x0C,0x09,0x03,0x05,0x0C,0x0C,0x0C,0x0A,0x06,0x0C,0x0C,0x0A,0x04,0x0C,0x08,0x06,
;0x0C,0x0C,0x09,0x06,0x08,0x04,0x0A,0x01,0x05,0x0A,0x06,0x09,0x06,0x0C,0x0E,0x0D,
;0x0A,0x04,0x0A,0x03,0x06,0x08,0x01,0x06,0x0C,0x09,0x03,0x06,0x09,0x02,0x05,0x0C,
;0x0D,0x0A,0x07,0x0B,0x05,0x0C,0x0A,0x05,0x0C,0x0C,0x09,0x03,0x06,0x09,0x02,0x06,
;0x0C,0x09,0x03,0x03,0x02,0x06,0x09,0x04,0x0C,0x0C,0x08,0x05,0x09,0x06,0x09,0x01,
;0x08,0x02,0x05,0x09,0x05,0x09,0x04,0x08,0x06,0x0C,0x0C,0x08,0x02,0x05,0x08,0x06,
;0x0E,0x0F,0x0A,0x06,0x0A,0x06,0x0A,0x02,0x07,0x0A,0x06,0x0A,0x03,0x02,0x06,0x0F
; };
;
;
;flash char sh[]={0x00,0x6E,0x2A,0x1E,0x1E,0x2A,0x6E,0x00};
;flash char mhome[]={0x00,0x7C,0x46,0x72,0x72,0x46,0x7C,0x00};
;flash char _maze[]=
;{
;0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
;0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
;0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
;0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
;0x81,0x81,0x81,0x81,0x81,0x81,0x81,0xFF,
;0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
;0xFF,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
;0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
;0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
;0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
;0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
;};
;
;
;
;void Clear_box(char x,char y){
; 0000 0026 void Clear_box(char x,char y){
_Clear_box:
;
; int i;
; char bg,BGM;
;
; bg=maze.map[xy(x,y)];
	CALL __SAVELOCR4
;	x -> Y+5
;	y -> Y+4
;	i -> R16,R17
;	bg -> R19
;	BGM -> R18
	LDD  R22,Y+5
	CLR  R23
	LDD  R26,Y+4
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;  ks0108_gotoxy(x*8,y);
	LDD  R30,Y+5
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+5
	ST   -Y,R30
	CALL _ks0108_gotoxy
;  if (bg==0){
	CPI  R19,0
	BRNE _0x77
;   for(i=0;i<8;i++)
	__GETWRN 16,17,0
_0x79:
	__CPWRN 16,17,8
	BRGE _0x7A
;    ks0108_Write(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _ks0108_Write
	__ADDWRN 16,17,1
	RJMP _0x79
_0x7A:
	RJMP _0x20C0018
; }
;
; for(i=0;i<8;i++){
_0x77:
	__GETWRN 16,17,0
_0x7C:
	__CPWRN 16,17,8
	BRGE _0x7D
;    BGM=_maze[(bg-1)*8+i];
	MOV  R30,R19
	LDI  R31,0
	SBIW R30,1
	CALL __LSLW3
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R18,Z
;    ks0108_Write(BGM);
	ST   -Y,R18
	CALL _ks0108_Write
;    }
	__ADDWRN 16,17,1
	RJMP _0x7C
_0x7D:
;}
	RJMP _0x20C0018
;
;void Drow_maze_one(char x,char y,char maz){
_Drow_maze_one:
;
; int i;
;  ks0108_gotoxy(x*8,y);
	ST   -Y,R17
	ST   -Y,R16
;	x -> Y+4
;	y -> Y+3
;	maz -> Y+2
;	i -> R16,R17
	LDD  R30,Y+4
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	CALL _ks0108_gotoxy
; if (maz==0){
	LDD  R30,Y+2
	CPI  R30,0
	BRNE _0x7E
;   for(i=0;i<8;i++)
	__GETWRN 16,17,0
_0x80:
	__CPWRN 16,17,8
	BRGE _0x81
;    ks0108_Write(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _ks0108_Write
	__ADDWRN 16,17,1
	RJMP _0x80
_0x81:
	RJMP _0x20C0015
; }
; for(i=0;i<8;i++)
_0x7E:
	__GETWRN 16,17,0
_0x83:
	__CPWRN 16,17,8
	BRGE _0x84
;    ks0108_Write(_maze[(maz-1)*8+i]);
	LDD  R30,Y+2
	LDI  R31,0
	SBIW R30,1
	CALL __LSLW3
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
	__ADDWRN 16,17,1
	RJMP _0x83
_0x84:
	RJMP _0x20C0015
;
;void Drow_Home(char x,char y){
_Drow_Home:
; int i;
; char bg,BGM;
;
; bg=maze.map[xy(x,y)];
	CALL __SAVELOCR4
;	x -> Y+5
;	y -> Y+4
;	i -> R16,R17
;	bg -> R19
;	BGM -> R18
	LDD  R22,Y+5
	CLR  R23
	LDD  R26,Y+4
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;
; ks0108_gotoxy(x*8,y);
	LDD  R30,Y+5
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+5
	ST   -Y,R30
	CALL _ks0108_gotoxy
; for(i=0;i<8;i++){
	__GETWRN 16,17,0
_0x86:
	__CPWRN 16,17,8
	BRGE _0x87
;    BGM=_maze[(bg-1)*8+i];
	MOV  R30,R19
	LDI  R31,0
	SBIW R30,1
	CALL __LSLW3
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R18,Z
;    ks0108_Write(mhome[i]|BGM);
	MOVW R30,R16
	SUBI R30,LOW(-_mhome*2)
	SBCI R31,HIGH(-_mhome*2)
	LPM  R30,Z
	OR   R30,R18
	ST   -Y,R30
	CALL _ks0108_Write
;    }
	__ADDWRN 16,17,1
	RJMP _0x86
_0x87:
;
;}
	RJMP _0x20C0018
;
;
;void Drow_maze(){
_Drow_maze:
; char i,j;
;
;  for(j=0;j<8;j++)
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R16,LOW(0)
_0x89:
	CPI  R16,8
	BRSH _0x8A
;    for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x8C:
	CPI  R17,16
	BRSH _0x8D
;        Drow_maze_one(i,j,maze.map[xy(i,j)]);
	ST   -Y,R17
	ST   -Y,R16
	MOV  R26,R17
	CLR  R27
	LDI  R30,LOW(16)
	MULS R30,R16
	MOVW R30,R0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	RCALL _Drow_maze_one
	SUBI R17,-1
	RJMP _0x8C
_0x8D:
	SUBI R16,-1
	RJMP _0x89
_0x8A:
_0x20C0019:
	LD   R16,Y+
	LD   R17,Y+
	RET
;
;
;void Drow_box(char x,char y){
_Drow_box:
;
; int i;
; char bg,BGM=0;
;
; bg=maze.map[xy(x,y)];
	CALL __SAVELOCR4
;	x -> Y+5
;	y -> Y+4
;	i -> R16,R17
;	bg -> R19
;	BGM -> R18
	LDI  R18,0
	LDD  R22,Y+5
	CLR  R23
	LDD  R26,Y+4
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;
; ks0108_gotoxy(x*8,y);
	LDD  R30,Y+5
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+5
	ST   -Y,R30
	CALL _ks0108_gotoxy
; for(i=0;i<8;i++){
	__GETWRN 16,17,0
_0x8F:
	__CPWRN 16,17,8
	BRGE _0x90
;    if(bg!=0)
	CPI  R19,0
	BREQ _0x91
;    BGM=_maze[(bg-1)*8+i];
	MOV  R30,R19
	LDI  R31,0
	SBIW R30,1
	CALL __LSLW3
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R18,Z
;    ks0108_Write(sh[i]|BGM);
_0x91:
	MOVW R30,R16
	SUBI R30,LOW(-_sh*2)
	SBCI R31,HIGH(-_sh*2)
	LPM  R30,Z
	OR   R30,R18
	ST   -Y,R30
	CALL _ks0108_Write
;    }
	__ADDWRN 16,17,1
	RJMP _0x8F
_0x90:
;}
_0x20C0018:
	CALL __LOADLOCR4
	ADIW R28,6
	RET
;
;
;void load_maze(char level){
_load_maze:
;
;  maze.p_x =maze_levels[level_len*level+0]-1;
;	level -> Y+0
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,0
	LPM  R30,Z
	LDI  R31,0
	SBIW R30,1
	STS  _maze,R30
;  maze.p_y =maze_levels[level_len*level+1]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,1
	LPM  R30,Z
	LDI  R31,0
	SBIW R30,1
	__PUTB1MN _maze,1
;  maze.s_x =maze_levels[level_len*level+0]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,0
	LPM  R30,Z
	LDI  R31,0
	SBIW R30,1
	__PUTB1MN _maze,2
;  maze.s_y =maze_levels[level_len*level+1]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,1
	LPM  R30,Z
	LDI  R31,0
	SBIW R30,1
	__PUTB1MN _maze,3
;  maze.e_x =maze_levels[level_len*level+2]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,2
	LPM  R30,Z
	LDI  R31,0
	SBIW R30,1
	__PUTB1MN _maze,4
;  maze.e_y =maze_levels[level_len*level+3]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,3
	LPM  R30,Z
	LDI  R31,0
	SBIW R30,1
	__PUTB1MN _maze,5
;  maze.map = maze_levels+level_len*level+4;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	SUBI R30,LOW(-_maze_levels*2)
	SBCI R31,HIGH(-_maze_levels*2)
	ADIW R30,4
	__PUTW1MN _maze,10
;  maze.move =0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	__PUTW1MN _maze,6
;
;  ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;  if(maze.hide==0)
	__GETB1MN _maze,9
	CPI  R30,0
	BRNE _0x92
;  Drow_maze();
	RCALL _Drow_maze
;  Drow_box(maze.p_x ,maze.p_y );
_0x92:
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Drow_box
;  Drow_Home(maze.e_x,maze.e_y );
	__GETB1MN _maze,4
	ST   -Y,R30
	__GETB1MN _maze,5
	ST   -Y,R30
	RCALL _Drow_Home
;}
_0x20C0017:
	ADIW R28,1
	RET
;
;void maze_init(){
_maze_init:
;maze.level=0 ;
	LDI  R30,LOW(0)
	__PUTB1MN _maze,8
;maze.hide =0;
	__PUTB1MN _maze,9
;load_maze(maze.level);
	__GETB1MN _maze,8
	ST   -Y,R30
	RCALL _load_maze
;
;}
	RET
;
;void move_right(void){
_move_right:
;   char bg;
;        if(maze.p_x == 15 )
	ST   -Y,R17
;	bg -> R17
	LDS  R26,_maze
	CPI  R26,LOW(0xF)
	BRNE _0x93
;            return;
	RJMP _0x20C0016
;        bg=maze.map[xy(maze.p_x ,maze.p_y )];
_0x93:
	LDS  R22,_maze
	CLR  R23
	__GETB2MN _maze,1
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;        if((bg&RIGHT)==0){
	SBRC R17,2
	RJMP _0x94
;        Clear_box(maze.p_x++,maze.p_y );
	LDS  R30,_maze
	SUBI R30,-LOW(1)
	STS  _maze,R30
	SUBI R30,LOW(1)
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Clear_box
;        Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Drow_box
;        maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;        }
;
;}
_0x94:
	RJMP _0x20C0016
;
;void move_left(void){
_move_left:
;
;   char bg;
;   if(maze.p_x == 0 )
	ST   -Y,R17
;	bg -> R17
	LDS  R30,_maze
	CPI  R30,0
	BRNE _0x95
;            return;
	RJMP _0x20C0016
;        bg=maze.map[xy(maze.p_x,maze.p_y)];
_0x95:
	LDS  R22,_maze
	CLR  R23
	__GETB2MN _maze,1
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;        if((bg&LEFT)==0){
	SBRC R17,3
	RJMP _0x96
;        Clear_box(maze.p_x--,maze.p_y);
	LDS  R30,_maze
	SUBI R30,LOW(1)
	STS  _maze,R30
	SUBI R30,-LOW(1)
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Clear_box
;        Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Drow_box
;        maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;        }
;
;}
_0x96:
	RJMP _0x20C0016
;
;void move_down(void){
_move_down:
;    char bg;
;            if(maze.p_y == 7 )
	ST   -Y,R17
;	bg -> R17
	__GETB2MN _maze,1
	CPI  R26,LOW(0x7)
	BRNE _0x97
;            return;
	RJMP _0x20C0016
;        bg=maze.map[xy(maze.p_x,maze.p_y)];
_0x97:
	LDS  R22,_maze
	CLR  R23
	__GETB2MN _maze,1
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;        if((bg&DOWN)==0){
	SBRC R17,1
	RJMP _0x98
;        Clear_box(maze.p_x,maze.p_y++);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	SUBI R30,-LOW(1)
	__PUTB1MN _maze,1
	SUBI R30,LOW(1)
	ST   -Y,R30
	RCALL _Clear_box
;        Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Drow_box
;        maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;        }
;
;}
_0x98:
	RJMP _0x20C0016
;
;
;void move_up(void){
_move_up:
;
;   char bg;
;        if(maze.p_y ==0 )
	ST   -Y,R17
;	bg -> R17
	__GETB1MN _maze,1
	CPI  R30,0
	BREQ _0x20C0016
;            return;
;        bg=maze.map[xy(maze.p_x,maze.p_y)];
	LDS  R22,_maze
	CLR  R23
	__GETB2MN _maze,1
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	__GETW2MN _maze,10
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;        if((bg&UP)==0){
	SBRC R17,0
	RJMP _0x9A
;        Clear_box(maze.p_x,maze.p_y--);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	SUBI R30,LOW(1)
	__PUTB1MN _maze,1
	SUBI R30,-LOW(1)
	ST   -Y,R30
	RCALL _Clear_box
;        Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	RCALL _Drow_box
;        maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;        }
;
;}
_0x9A:
_0x20C0016:
	LD   R17,Y+
	RET
;
;char maze_win(){
_maze_win:
;
;char temp[5];
;ks0108_ClearScreen();
	SBIW R28,5
;	temp -> Y+0
	CALL _ks0108_ClearScreen
;
;lputsf(20,0,"YOU WON Level ");
	LDI  R30,LOW(20)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	__POINTW1FN _0x0,0
	ST   -Y,R31
	ST   -Y,R30
	RCALL _lputsf
;put_char(100,0,'0'+(maze.level+maze.hide*4 ));
	LDI  R30,LOW(100)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB2MN _maze,8
	__GETB1MN _maze,9
	LSL  R30
	LSL  R30
	ADD  R30,R26
	SUBI R30,-LOW(48)
	ST   -Y,R30
	RCALL _put_char
;lputsf(7,2,"For New Game Press");
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__POINTW1FN _0x0,15
	ST   -Y,R31
	ST   -Y,R30
	RCALL _lputsf
;lputsf(40,3,"<-ENTER->");
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__POINTW1FN _0x0,34
	ST   -Y,R31
	ST   -Y,R30
	RCALL _lputsf
;lputsf(5,4,"Or Esc To Exit Game.");
	LDI  R30,LOW(5)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	__POINTW1FN _0x0,44
	ST   -Y,R31
	ST   -Y,R30
	RCALL _lputsf
;
;sprintf(temp,"%i",maze.move);
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x0,65
	ST   -Y,R31
	ST   -Y,R30
	__GETW1MN _maze,6
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
;lputsf(10,6,"Total Movment is ");
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(6)
	ST   -Y,R30
	__POINTW1FN _0x0,68
	ST   -Y,R31
	ST   -Y,R30
	RCALL _lputsf
;lputs(60,7,temp);
	LDI  R30,LOW(60)
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	RCALL _lputs
;maze.level++;
	__GETB1MN _maze,8
	SUBI R30,-LOW(1)
	__PUTB1MN _maze,8
	SUBI R30,LOW(1)
;if(maze.level>4 && maze.hide ==0)
	__GETB2MN _maze,8
	CPI  R26,LOW(0x5)
	BRLO _0x9C
	__GETB2MN _maze,9
	CPI  R26,LOW(0x0)
	BREQ _0x9D
_0x9C:
	RJMP _0x9B
_0x9D:
;{
;maze.level=0;
	LDI  R30,LOW(0)
	__PUTB1MN _maze,8
;maze.hide=1;
	LDI  R30,LOW(1)
	__PUTB1MN _maze,9
;}else if(maze.level>=4 && maze.hide ==1){
	RJMP _0x9E
_0x9B:
	__GETB2MN _maze,8
	CPI  R26,LOW(0x4)
	BRLO _0xA0
	__GETB2MN _maze,9
	CPI  R26,LOW(0x1)
	BREQ _0xA1
_0xA0:
	RJMP _0x9F
_0xA1:
; //End OF Game
; while(1){
_0xA2:
;        if (get_key_press(1<<BTN_EN)){
	LDI  R30,LOW(64)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xA5
;        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;       return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C0014
;       }
;       if (get_key_press(1<<BTN_ES)){
_0xA5:
	LDI  R30,LOW(2)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xA6
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;       return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C0014
;       }
; }
_0xA6:
	RJMP _0xA2
;}
;
;while(1){
_0x9F:
_0x9E:
_0xA7:
;
;
;       if (get_key_press(1<<BTN_EN)){
	LDI  R30,LOW(64)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xAA
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;       load_maze(maze.level);
	__GETB1MN _maze,8
	ST   -Y,R30
	RCALL _load_maze
;       return 1;
	LDI  R30,LOW(1)
	RJMP _0x20C0014
;       }
;
;        if (get_key_press(1<<BTN_ES)){
_0xAA:
	LDI  R30,LOW(2)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xAB
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;       return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C0014
;       }
;}
_0xAB:
	RJMP _0xA7
;}
;
;
;void Run_maze(void){
_Run_maze:
;
;ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;maze_init();
	RCALL _maze_init
;light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _light_on
;play_sound(maze_sound);
	LDI  R30,LOW(_maze_sound*2)
	LDI  R31,HIGH(_maze_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _play_sound
;
;
;while (1)
_0xAC:
;      {
;        if(maze.e_x == maze.p_x  && maze.e_y == maze.p_y){
	__GETB2MN _maze,4
	LDS  R30,_maze
	CP   R30,R26
	BRNE _0xB0
	__GETB2MN _maze,5
	__GETB1MN _maze,1
	CP   R30,R26
	BREQ _0xB1
_0xB0:
	RJMP _0xAF
_0xB1:
;        if(maze_win()==0)
	RCALL _maze_win
	CPI  R30,0
	BRNE _0xB2
;            break;
	RJMP _0xAE
;        }
_0xB2:
;
;        if (get_key_press(1<<BTN_MD))
_0xAF:
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xB3
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0xB4
;                stop_sound();
	RCALL _stop_sound
;            else
	RJMP _0xB5
_0xB4:
;                play_sound(maze_sound);
	LDI  R30,LOW(_maze_sound*2)
	LDI  R31,HIGH(_maze_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _play_sound
;
;       if (get_key_press(1<<BTN_RT)){
_0xB5:
_0xB3:
	LDI  R30,LOW(32)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xB6
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;        move_right();
	RCALL _move_right
;       }
;
;       if (get_key_press(1<<BTN_LT)){
_0xB6:
	LDI  R30,LOW(4)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xB7
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;        move_left();
	RCALL _move_left
;       }
;
;       if (get_key_press(1<<BTN_DN)){
_0xB7:
	LDI  R30,LOW(8)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xB8
;        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;        move_down();
	RCALL _move_down
;        }
;
;       if (get_key_press(1<<BTN_UP)){
_0xB8:
	LDI  R30,LOW(16)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xB9
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;        move_up();
	RCALL _move_up
;        }
;
;       if (get_key_press(1<<BTN_ES)){
_0xB9:
	LDI  R30,LOW(2)
	ST   -Y,R30
	RCALL _get_key_press
	CPI  R30,0
	BREQ _0xBA
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _paly_sound_key
;       light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _light_off
;        break;
	RJMP _0xAE
;        }
;      };
_0xBA:
	RJMP _0xAC
_0xAE:
;
;}
	RET
;#include "game's/tetris.c"
;//
;#define BOX_board_bottom 21
;#define BOX_board_right 11
;
;#define array_size (((BOX_board_bottom+8)/8) * (BOX_board_right + 1))
;
;#define default_fg_color 1
;#define default_bg_color 0
;#define GLCD_GoTo(x,y)   ks0108_gotoxy(x,y)
;#define GLCD_WriteData(dat) ks0108_Write(dat)
;
;#define white 0
;
;unsigned char BOX_piece[4];
;char __PPPTT=0;
;flash char  BOX_reference[7][4][4] = {
;        //T
;        {
;                {
;                        0b00000010,
;                        0b00000011,
;                        0b00000010,
;                        0b00000000
;                },
;
;                {
;                        0b00000000,
;                        0b00000111,
;                        0b00000010,
;                        0b00000000
;                },
;
;                {
;                        0b00000001,
;                        0b00000011,
;                        0b00000001,
;                        0b00000000
;                },
;
;                {
;                        0b00000010,
;                        0b00000111,
;                        0b00000000,
;                        0b00000000
;                }
;        },
;
;        // S
;        {
;                {
;                        0b00000010,
;                        0b00000011,
;                        0b00000001,
;                        0b00000000
;                },
;
;                {
;                        0b00000011,
;                        0b00000110,
;                        0b00000000,
;                        0b00000000
;                },
;
;                {
;                        0b00000010,
;                        0b00000011,
;                        0b00000001,
;                        0b00000000
;                },
;
;                {
;                        0b00000011,
;                        0b00000110,
;                        0b00000000,
;                        0b00000000
;                }
;        },
;
;        // Z
;        {
;                {
;                        0b00000001,
;                        0b00000011,
;                        0b00000010,
;                        0b00000000
;                },
;
;                {
;                        0b00000110,
;                        0b00000011,
;                        0b00000000,
;                        0b00000000
;                },
;
;                {
;                        0b00000001,
;                        0b00000011,
;                        0b00000010,
;                        0b00000000
;                },
;
;                {
;                        0b00000110,
;                        0b00000011,
;                        0b00000000,
;                        0b00000000
;                }
;        },
;
;        // L
;        {
;                {
;                        0b00000011,
;                        0b00000001,
;                        0b00000001,
;                        0b00000000
;                },
;
;                {
;                        0b00000000,
;                        0b00000001,
;                        0b00000111,
;                        0b00000000
;                },
;
;                {
;                        0b00000010,
;                        0b00000010,
;                        0b00000011,
;                        0b00000000
;                },
;
;                {
;                        0b00000000,
;                        0b00000111,
;                        0b00000100,
;                        0b00000000
;                }
;        },
;
;        // J
;        {
;                {
;                        0b00000001,
;                        0b00000001,
;                        0b00000011,
;                        0b00000000
;                },
;
;                {
;                        0b00000000,
;                        0b00000100,
;                        0b00000111,
;                        0b00000000
;                },
;
;                {
;                        0b00000011,
;                        0b00000010,
;                        0b00000010,
;                        0b00000000
;                },
;
;                {
;                        0b00000000,
;                        0b00000111,
;                        0b00000001,
;                        0b00000000
;                }
;        },
;
;        // Box
;        {
;                {
;                        0b00000011,
;                        0b00000011,
;                        0b00000000,
;                        0b00000000
;                },
;
;                {
;                        0b00000011,
;                        0b00000011,
;                        0b00000000,
;                        0b00000000
;                },
;
;                {
;                        0b00000011,
;                        0b00000011,
;                        0b00000000,
;                        0b00000000
;                },
;
;                {
;                        0b00000011,
;                        0b00000011,
;                        0b00000000,
;                        0b00000000
;                }
;        },
;
;        // Line
;        {
;                {
;                        0b00000010,
;                        0b00000010,
;                        0b00000010,
;                        0b00000010
;                },
;
;                {
;                        0b00000000,
;                        0b00001111,
;                        0b00000000,
;                        0b00000000
;                },
;
;                {
;                        0b00000010,
;                        0b00000010,
;                        0b00000010,
;                        0b00000010
;                },
;
;                {
;                        0b00000000,
;                        0b00001111,
;                        0b00000000,
;                        0b00000000
;                }
;        }
;};
;flash char  message1[] = { "**Tetris**    Game!" };
;flash char  message2[] = { "Pres Enter"} ;
;flash char  message3[] = { " To start" };
;flash char  message4[] = { "Game Over" };
;flash char  message5[] = { "Lines:" };
;
;//Variables
;unsigned char BOX_location[array_size];
;unsigned char x_loc, y_loc;     //Bottom left index of each piece
;unsigned char cur_piece = 0;	//Index for BOX_reference
;unsigned char rotate = 0;		//Index for piece rotation
;unsigned char score;		//Track the number of rows completed
;
;/**********************************************
; * Functions that handle bits in BOX_location[]
; * BOX_loc_return_bit
; * BOX_loc_set_bit
; * BOX_loc_clear_bit
; ************************************************/
;
;unsigned char BOX_loc_return_bit(unsigned char X, unsigned char Y)
; 0000 0027 {
_BOX_loc_return_bit:
;  //Calculate array index and shift amount
;  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
;  unsigned char shift_index ;		//How much to shift for our bit mask
;
;  shift_index = (Y)%8;		//How much to shift for our bit mask
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+3
;	Y -> Y+2
;	array_index_offset -> R17
;	shift_index -> R16
	LDD  R26,Y+2
	LDI  R27,0
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __DIVW21
	LDI  R26,LOW(12)
	MULS R30,R26
	MOVW R30,R0
	MOV  R17,R30
	LDD  R26,Y+2
	CLR  R27
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MODW21
	MOV  R16,R30
;  if (BOX_location[X+array_index_offset] & 1<<shift_index) return 1;
	LDD  R26,Y+3
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_BOX_location)
	SBCI R31,HIGH(-_BOX_location)
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0xBB
	LDI  R30,LOW(1)
	RJMP _0x20C0013
;  else return 0;
_0xBB:
	LDI  R30,LOW(0)
	RJMP _0x20C0013
;}
;
;void BOX_draw(unsigned char X, unsigned char Y, unsigned char color)
;{
_BOX_draw:
;	  unsigned char temp_data;
;      unsigned char i;
;	  if (X%2)
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+4
;	Y -> Y+3
;	color -> Y+2
;	temp_data -> R17
;	i -> R16
	LDD  R26,Y+4
	CLR  R27
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __MODW21
	SBIW R30,0
	BREQ _0xBD
;	  {
;		  if (BOX_loc_return_bit(X-1,Y)) temp_data = 0xFF;
	LDD  R30,Y+4
	LDI  R31,0
	SBIW R30,1
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0xBE
	LDI  R17,LOW(255)
;		  else temp_data = 240;//0xF0;
	RJMP _0xBF
_0xBE:
	LDI  R17,LOW(240)
;	  }
_0xBF:
;	  else
	RJMP _0xC0
_0xBD:
;	  {
;		  if (BOX_loc_return_bit(X+1,Y)) temp_data = 0xFF;
	LDD  R30,Y+4
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0xC1
	LDI  R17,LOW(255)
;		  else temp_data = 0x0F;
	RJMP _0xC2
_0xC1:
	LDI  R17,LOW(15)
;	  }
_0xC2:
_0xC0:
;	  Y = (BOX_board_bottom*4)-(Y*4);
	LDD  R26,Y+3
	LDI  R30,LOW(4)
	MULS R30,R26
	MOVW R30,R0
	LDI  R26,LOW(84)
	LDI  R27,HIGH(84)
	CALL __SWAPW12
	SUB  R30,R26
	STD  Y+3,R30
;	  ks0108_gotoxy(Y+8, (X/2)+1);
	SUBI R30,-LOW(8)
	ST   -Y,R30
	LDD  R26,Y+5
	LDI  R27,0
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __DIVW21
	SUBI R30,-LOW(1)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;	  for (i=0; i<4; i++)
	LDI  R16,LOW(0)
_0xC4:
	CPI  R16,4
	BRSH _0xC5
;	  {
;		  ks0108_Write(temp_data);
	ST   -Y,R17
	CALL _ks0108_Write
;	  }
	SUBI R16,-1
	RJMP _0xC4
_0xC5:
;}
_0x20C0015:
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x20C0014:
	ADIW R28,5
	RET
;
;void BOX_erase(unsigned char X, unsigned char Y)
;{
_BOX_erase:
;	  unsigned char temp_data;
;      unsigned char i;
;
;	  if (X%2)
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+3
;	Y -> Y+2
;	temp_data -> R17
;	i -> R16
	LDD  R26,Y+3
	CLR  R27
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __MODW21
	SBIW R30,0
	BREQ _0xC6
;	  {
;		  if (BOX_loc_return_bit(X-1,Y)) temp_data = 0x0F;
	LDD  R30,Y+3
	LDI  R31,0
	SBIW R30,1
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0xC7
	LDI  R17,LOW(15)
;		  else temp_data = 0x00;
	RJMP _0xC8
_0xC7:
	LDI  R17,LOW(0)
;	  }
_0xC8:
;	  else
	RJMP _0xC9
_0xC6:
;	  {
;		  if (BOX_loc_return_bit(X+1,Y)) temp_data = 240;//0xF0;
	LDD  R30,Y+3
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0xCA
	LDI  R17,LOW(240)
;		  else temp_data = 0x00;
	RJMP _0xCB
_0xCA:
	LDI  R17,LOW(0)
;	  }
_0xCB:
_0xC9:
;	  Y = (BOX_board_bottom*4)-(Y*4);
	LDD  R26,Y+2
	LDI  R30,LOW(4)
	MULS R30,R26
	MOVW R30,R0
	LDI  R26,LOW(84)
	LDI  R27,HIGH(84)
	CALL __SWAPW12
	SUB  R30,R26
	STD  Y+2,R30
;	  ks0108_gotoxy(Y+8, (X/2)+1);
	SUBI R30,-LOW(8)
	ST   -Y,R30
	LDD  R26,Y+4
	LDI  R27,0
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __DIVW21
	SUBI R30,-LOW(1)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;	  for (i=0; i<4; i++)
	LDI  R16,LOW(0)
_0xCD:
	CPI  R16,4
	BRSH _0xCE
;	  {
;		  ks0108_Write(temp_data);
	ST   -Y,R17
	CALL _ks0108_Write
;	  }
	SUBI R16,-1
	RJMP _0xCD
_0xCE:
;}
	RJMP _0x20C0013
;
;
;void BOX_update_score(void)  //TODO: horrible hack --- clean this up!
;{
_BOX_update_score:
;	//Update the score on the display
;	unsigned char score_array[14];
;	unsigned char tens = score/10;
;        unsigned char ones = score%10;
;	unsigned char char_column_info;
;	unsigned char i,j;
;        tens += 16; //Adjustment for font5x8.h
	SBIW R28,14
	CALL __SAVELOCR6
;	score_array -> Y+6
;	tens -> R17
;	ones -> R16
;	char_column_info -> R19
;	i -> R18
;	j -> R21
	MOV  R26,R13
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	MOV  R17,R30
	MOV  R26,R13
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	MOV  R16,R30
	SUBI R17,-LOW(16)
;	ones += 16; //Adjustment for font5x8.h
	SUBI R16,-LOW(16)
;
;	//Preload the background data to make this look pretty
;	for (i=0; i<4; i++)
	LDI  R18,LOW(0)
_0xD0:
	CPI  R18,4
	BRSH _0xD1
;	{
;	        score_array[(i*2)+7] = 0b10110000;
	LDI  R30,LOW(2)
	MULS R30,R18
	MOVW R30,R0
	ADIW R30,7
	MOVW R26,R28
	ADIW R26,6
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(176)
	ST   X,R30
;	    score_array[(i*2)+8] = 0b01010000;
	LDI  R30,LOW(2)
	MULS R30,R18
	MOVW R30,R0
	ADIW R30,8
	MOVW R26,R28
	ADIW R26,6
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(80)
	ST   X,R30
;	}
	SUBI R18,-1
	RJMP _0xD0
_0xD1:
;
;
;
;	for (i=0; i<5; i++)
	LDI  R18,LOW(0)
_0xD3:
	CPI  R18,5
	BRLO PC+3
	JMP _0xD4
;	{
;		char_column_info = *(font + (5 * tens) + i); //Read column in from font5x8.h
	LDI  R26,LOW(5)
	MULS R17,R26
	MOVW R30,R0
	SUBI R30,LOW(-_font*2)
	SBCI R31,HIGH(-_font*2)
	MOVW R26,R30
	MOV  R30,R18
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;		for (j=0; j<7; j++)
	LDI  R21,LOW(0)
_0xD6:
	CPI  R21,7
	BRSH _0xD7
;		{
;			if (char_column_info & (1<<(6-j))) score_array[j] |= 1<<i;
	MOV  R30,R21
	LDI  R31,0
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R19
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0xD8
	MOV  R30,R21
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R18
	LDI  R26,LOW(1)
	CALL __LSLB12
	OR   R30,R1
	RJMP _0x277
;			else score_array[j] &= ~(1<<i);
_0xD8:
	MOV  R30,R21
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R18
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R1
_0x277:
	MOVW R26,R22
	ST   X,R30
;		}
	SUBI R21,-1
	RJMP _0xD6
_0xD7:
;
;	}
	SUBI R18,-1
	RJMP _0xD3
_0xD4:
;	for (j=0; j<7; j++) score_array[j] &= ~(1<<5); //Space between number
	LDI  R21,LOW(0)
_0xDB:
	CPI  R21,7
	BRSH _0xDC
	MOV  R30,R21
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	ANDI R30,0xDF
	ST   X,R30
	SUBI R21,-1
	RJMP _0xDB
_0xDC:
	LDI  R18,LOW(6)
_0xDE:
	CPI  R18,8
	BRLO PC+3
	JMP _0xDF
;	{
;		char_column_info = *(font + (5 * ones) + (i-6)); //Read column in from font5x8.h
	LDI  R26,LOW(5)
	MULS R16,R26
	MOVW R30,R0
	SUBI R30,LOW(-_font*2)
	SBCI R31,HIGH(-_font*2)
	MOVW R26,R30
	MOV  R30,R18
	LDI  R31,0
	SBIW R30,6
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;		for (j=0; j<7; j++)
	LDI  R21,LOW(0)
_0xE1:
	CPI  R21,7
	BRSH _0xE2
;		{
;			if (char_column_info & (1<<(6-j))) score_array[j] |= 1<<i;
	MOV  R30,R21
	LDI  R31,0
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R19
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0xE3
	MOV  R30,R21
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R18
	LDI  R26,LOW(1)
	CALL __LSLB12
	OR   R30,R1
	RJMP _0x278
;			else score_array[j] &= ~(1<<i);
_0xE3:
	MOV  R30,R21
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R18
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R1
_0x278:
	MOVW R26,R22
	ST   X,R30
;		}
	SUBI R21,-1
	RJMP _0xE1
_0xE2:
;	}
	SUBI R18,-1
	RJMP _0xDE
_0xDF:
;	for (i=0; i<3; i++)
	LDI  R18,LOW(0)
_0xE6:
	CPI  R18,3
	BRLO PC+3
	JMP _0xE7
;	{
;		char_column_info = *(font + (5 * ones) + (i+2)); //Read column in from font5x8.h
	LDI  R26,LOW(5)
	MULS R16,R26
	MOVW R30,R0
	SUBI R30,LOW(-_font*2)
	SBCI R31,HIGH(-_font*2)
	MOVW R26,R30
	MOV  R30,R18
	LDI  R31,0
	ADIW R30,2
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;		for (j=0; j<7; j++)
	LDI  R21,LOW(0)
_0xE9:
	CPI  R21,7
	BRSH _0xEA
;		{
;			if (char_column_info & (1<<(6-j))) score_array[j+7] |= 1<<i;
	MOV  R30,R21
	LDI  R31,0
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R19
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0xEB
	MOV  R30,R21
	LDI  R31,0
	ADIW R30,7
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R18
	LDI  R26,LOW(1)
	CALL __LSLB12
	OR   R30,R1
	RJMP _0x279
;			else score_array[j+7] &= ~(1<<i);
_0xEB:
	MOV  R30,R21
	LDI  R31,0
	ADIW R30,7
	MOVW R26,R28
	ADIW R26,6
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R18
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R1
_0x279:
	MOVW R26,R22
	ST   X,R30
;		}
	SUBI R21,-1
	RJMP _0xE9
_0xEA:
;	}
	SUBI R18,-1
	RJMP _0xE6
_0xE7:
;
;	GLCD_GoTo(110,6);
	LDI  R30,LOW(110)
	ST   -Y,R30
	LDI  R30,LOW(6)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;	for (i=0; i<7; i++) GLCD_WriteData(score_array[i]);
	LDI  R18,LOW(0)
_0xEE:
	CPI  R18,7
	BRSH _0xEF
	MOV  R30,R18
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,6
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	ST   -Y,R30
	CALL _ks0108_Write
	SUBI R18,-1
	RJMP _0xEE
_0xEF:
	LDI  R30,LOW(110)
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;	for (i=0; i<7; i++) GLCD_WriteData(score_array[i+7]);
	LDI  R18,LOW(0)
_0xF1:
	CPI  R18,7
	BRSH _0xF2
	MOV  R30,R18
	LDI  R31,0
	ADIW R30,7
	MOVW R26,R28
	ADIW R26,6
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	ST   -Y,R30
	CALL _ks0108_Write
	SUBI R18,-1
	RJMP _0xF1
_0xF2:
	CALL __LOADLOCR6
	ADIW R28,20
	RET
;
;void BOX_rewrite_display(unsigned char fgcolor, unsigned char bgcolor)	//Rewrites entire playing area
;{
_BOX_rewrite_display:
;  unsigned char cols;
;  unsigned char rows;
;
;  for (cols=0; cols<=BOX_board_right; cols++)
	ST   -Y,R17
	ST   -Y,R16
;	fgcolor -> Y+3
;	bgcolor -> Y+2
;	cols -> R17
;	rows -> R16
	LDI  R17,LOW(0)
_0xF4:
	CPI  R17,12
	BRSH _0xF5
;  {
;	  for (rows=0; rows<=BOX_board_bottom; rows++)
	LDI  R16,LOW(0)
_0xF7:
	CPI  R16,22
	BRSH _0xF8
;	  {
;		  if(BOX_loc_return_bit(cols,rows)) BOX_draw(cols,rows,fgcolor);
	ST   -Y,R17
	ST   -Y,R16
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0xF9
	ST   -Y,R17
	ST   -Y,R16
	LDD  R30,Y+5
	ST   -Y,R30
	RCALL _BOX_draw
;		  else BOX_erase(cols,rows);
	RJMP _0xFA
_0xF9:
	ST   -Y,R17
	ST   -Y,R16
	RCALL _BOX_erase
;	  }
_0xFA:
	SUBI R16,-1
	RJMP _0xF7
_0xF8:
;  }
	SUBI R17,-1
	RJMP _0xF4
_0xF5:
;}
	RJMP _0x20C0013
;
;void BOX_load_reference(unsigned char piece, unsigned char rotation)
;{
_BOX_load_reference:
;	  BOX_piece[0] = BOX_reference[piece][rotation][0];
;	piece -> Y+1
;	rotation -> Y+0
	LDD  R30,Y+1
	LDI  R31,0
	CALL __LSLW4
	SUBI R30,LOW(-_BOX_reference*2)
	SBCI R31,HIGH(-_BOX_reference*2)
	MOVW R26,R30
	LD   R30,Y
	LDI  R31,0
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	LPM  R0,Z
	STS  _BOX_piece,R0
;	  BOX_piece[1] = BOX_reference[piece][rotation][1];
	LDD  R30,Y+1
	LDI  R31,0
	CALL __LSLW4
	SUBI R30,LOW(-_BOX_reference*2)
	SBCI R31,HIGH(-_BOX_reference*2)
	MOVW R26,R30
	LD   R30,Y
	LDI  R31,0
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,1
	LPM  R0,Z
	__PUTBR0MN _BOX_piece,1
;	  BOX_piece[2] = BOX_reference[piece][rotation][2];
	LDD  R30,Y+1
	LDI  R31,0
	CALL __LSLW4
	SUBI R30,LOW(-_BOX_reference*2)
	SBCI R31,HIGH(-_BOX_reference*2)
	MOVW R26,R30
	LD   R30,Y
	LDI  R31,0
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LPM  R0,Z
	__PUTBR0MN _BOX_piece,2
;	  BOX_piece[3] = BOX_reference[piece][rotation][3];
	LDD  R30,Y+1
	LDI  R31,0
	CALL __LSLW4
	SUBI R30,LOW(-_BOX_reference*2)
	SBCI R31,HIGH(-_BOX_reference*2)
	MOVW R26,R30
	LD   R30,Y
	LDI  R31,0
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,3
	LPM  R0,Z
	__PUTBR0MN _BOX_piece,3
;}
	RJMP _0x20C000F
;
;
;
;void BOX_loc_set_bit(unsigned char X, unsigned char Y)
;{
_BOX_loc_set_bit:
;  //Calculate array index and shift amount
;  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
;  unsigned char shift_index = (Y)%8;		//How much to shift for our bit mask
;
;  BOX_location[X+array_index_offset] |= 1<<shift_index;
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+3
;	Y -> Y+2
;	array_index_offset -> R17
;	shift_index -> R16
	LDD  R26,Y+2
	LDI  R27,0
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __DIVW21
	LDI  R26,LOW(12)
	MULS R30,R26
	MOVW R30,R0
	MOV  R17,R30
	LDD  R26,Y+2
	CLR  R27
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MODW21
	MOV  R16,R30
	LDD  R26,Y+3
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_BOX_location)
	SBCI R31,HIGH(-_BOX_location)
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	CALL __LSLB12
	OR   R30,R1
	RJMP _0x20C0012
;}
;
;void BOX_loc_clear_bit(unsigned char X, unsigned char Y)
;{
_BOX_loc_clear_bit:
;  //Calculate array index and shift amount
;  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
;  unsigned char shift_index = (Y)%8;		//How much to shift for our bit mask
;
;  BOX_location[X+array_index_offset] &= ~(1<<shift_index);
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+3
;	Y -> Y+2
;	array_index_offset -> R17
;	shift_index -> R16
	LDD  R26,Y+2
	LDI  R27,0
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __DIVW21
	LDI  R26,LOW(12)
	MULS R30,R26
	MOVW R30,R0
	MOV  R17,R30
	LDD  R26,Y+2
	CLR  R27
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MODW21
	MOV  R16,R30
	LDD  R26,Y+3
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_BOX_location)
	SBCI R31,HIGH(-_BOX_location)
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R1
_0x20C0012:
	MOVW R26,R22
	ST   X,R30
;}
_0x20C0013:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,4
	RET
;
;void BOX_clear_loc(void)
;{
_BOX_clear_loc:
;  //Step through 4 columns
;  unsigned char temp_col;
;  unsigned char temp_row;
;
;  for ( temp_col=0; temp_col<4; temp_col++)
	ST   -Y,R17
	ST   -Y,R16
;	temp_col -> R17
;	temp_row -> R16
	LDI  R17,LOW(0)
_0xFC:
	CPI  R17,4
	BRLO PC+3
	JMP _0xFD
;  {
;    //Only if x_loc is not out of bounds
;    if ((unsigned char)(x_loc+temp_col) <= BOX_board_right)
	MOV  R26,R9
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LDI  R31,0
	CPI  R30,LOW(0xC)
	BRSH _0xFE
;    {
;      //Step through 4 rows
;      for (temp_row=0; temp_row<4; temp_row++)
	LDI  R16,LOW(0)
_0x100:
	CPI  R16,4
	BRSH _0x101
;      {
;		//Only if y_loc is not out of bounds
;		if (y_loc-temp_row <= BOX_board_bottom)
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	SBIW R26,22
	BRGE _0x102
;		{
;		  if (BOX_piece[temp_col] & 1<<(temp_row))	//Checks nibbles in Box_piece array
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_BOX_piece)
	SBCI R31,HIGH(-_BOX_piece)
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x103
;		  {
;			BOX_loc_clear_bit((unsigned char)(x_loc+temp_col),y_loc-temp_row);
	MOV  R30,R17
	ADD  R30,R9
	ST   -Y,R30
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	ST   -Y,R26
	RCALL _BOX_loc_clear_bit
;		  }
;		}
_0x103:
;      }
_0x102:
	SUBI R16,-1
	RJMP _0x100
_0x101:
;    }
;  }
_0xFE:
	SUBI R17,-1
	RJMP _0xFC
_0xFD:
;}
	RJMP _0x20C0010
;
;void BOX_store_loc(void)
;{
_BOX_store_loc:
;  unsigned char temp_col;
;  unsigned char temp_row;
;  //Step through 4 columns
;  for (temp_col=0; temp_col<4; temp_col++)
	ST   -Y,R17
	ST   -Y,R16
;	temp_col -> R17
;	temp_row -> R16
	LDI  R17,LOW(0)
_0x105:
	CPI  R17,4
	BRLO PC+3
	JMP _0x106
;  {
;    //Only if x_loc is not out of bounds
;    if ((unsigned char)(x_loc+temp_col) <= BOX_board_right)
	MOV  R26,R9
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LDI  R31,0
	CPI  R30,LOW(0xC)
	BRSH _0x107
;    {
;      //Step through 4 rows
;      for (temp_row=0; temp_row<4; temp_row++)
	LDI  R16,LOW(0)
_0x109:
	CPI  R16,4
	BRSH _0x10A
;      {
;		//Only if y_loc is not out of bounds
;		if (y_loc-temp_row <= BOX_board_bottom)
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	SBIW R26,22
	BRGE _0x10B
;		{
;		  if (BOX_piece[temp_col] & 1<<(temp_row))	//Checks nibbles in Box_piece array
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_BOX_piece)
	SBCI R31,HIGH(-_BOX_piece)
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x10C
;		  {
;			BOX_loc_set_bit((unsigned char)(x_loc+temp_col),y_loc-temp_row);
	MOV  R30,R17
	ADD  R30,R9
	ST   -Y,R30
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	ST   -Y,R26
	RCALL _BOX_loc_set_bit
;		  }
;		}
_0x10C:
;      }
_0x10B:
	SUBI R16,-1
	RJMP _0x109
_0x10A:
;    }
;  }
_0x107:
	SUBI R17,-1
	RJMP _0x105
_0x106:
;}
	RJMP _0x20C0010
;
;unsigned char BOX_check(signed char X_offset, signed char Y_offset)
;{
_BOX_check:
;	unsigned char temp_area[4] = { 0x00, 0x00, 0x00, 0x00 };
;	unsigned char i;
;    unsigned char j;
;	//Build compare mask in temp_area[]
;
;		//Clear the current piece from BOX_location[] so we don't have a false overlap
;			//Do this only if X_offset and Y_offset aren't both 0 (used for BOX_spawn)
;		if (X_offset || Y_offset) BOX_clear_loc();
	SBIW R28,4
	LDI  R30,LOW(0)
	ST   Y,R30
	STD  Y+1,R30
	STD  Y+2,R30
	STD  Y+3,R30
	ST   -Y,R17
	ST   -Y,R16
;	X_offset -> Y+7
;	Y_offset -> Y+6
;	temp_area -> Y+2
;	i -> R17
;	j -> R16
	LDD  R30,Y+7
	CPI  R30,0
	BRNE _0x10E
	LDD  R30,Y+6
	CPI  R30,0
	BREQ _0x10D
_0x10E:
	RCALL _BOX_clear_loc
;		//mask will be 4 sets of nibbles (2 bytes)
;		for (i=0; i<4; i++)
_0x10D:
	LDI  R17,LOW(0)
_0x111:
	CPI  R17,4
	BRLO PC+3
	JMP _0x112
;		{
;			//if out of bounds on the x axis
;			if ((unsigned char)(x_loc+X_offset+i) > BOX_board_right) temp_area[i] = 0x0F;
	MOV  R26,R9
	CLR  R27
	LDD  R30,Y+7
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LDI  R31,0
	CPI  R30,LOW(0xC)
	BRLO _0x113
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,2
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(15)
	ST   X,R30
;			else
	RJMP _0x114
_0x113:
;			{
;				for (j=0; j<4; j++)
	LDI  R16,LOW(0)
_0x116:
	CPI  R16,4
	BRSH _0x117
;				{
;					//if we're out of bounds on the y axis
;					if (((unsigned char)(y_loc+Y_offset-j) > BOX_board_bottom) ||
;					   (BOX_loc_return_bit((unsigned char)(x_loc+X_offset+i),(unsigned char)(y_loc+Y_offset-j))))
	MOV  R26,R12
	CLR  R27
	LDD  R30,Y+6
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R16
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDI  R31,0
	CPI  R30,LOW(0x16)
	BRSH _0x119
	LDD  R30,Y+7
	ADD  R30,R9
	ADD  R30,R17
	ST   -Y,R30
	MOV  R26,R12
	CLR  R27
	LDD  R30,Y+7
	LDI  R31,0
	SBRC R30,7
	SER  R31
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	ST   -Y,R26
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0x118
_0x119:
;					{
;						temp_area[i] |= 1<<j;
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,2
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	CALL __LSLB12
	OR   R30,R1
	MOVW R26,R22
	ST   X,R30
;					}
;				}
_0x118:
	SUBI R16,-1
	RJMP _0x116
_0x117:
;			}
_0x114:
;		}
	SUBI R17,-1
	RJMP _0x111
_0x112:
;		if (X_offset || Y_offset) BOX_store_loc(); //Restore the location we cleared earlier
	LDD  R30,Y+7
	CPI  R30,0
	BRNE _0x11C
	LDD  R30,Y+6
	CPI  R30,0
	BREQ _0x11B
_0x11C:
	RCALL _BOX_store_loc
;
;	if ((temp_area[0] & BOX_piece[0]) | (temp_area[1] & BOX_piece[1]) | (temp_area[2] & BOX_piece[2]) | (temp_area[3] & BOX_piece[3]))
_0x11B:
	LDS  R30,_BOX_piece
	LDD  R26,Y+2
	AND  R30,R26
	MOV  R0,R30
	__GETB1MN _BOX_piece,1
	LDD  R26,Y+3
	AND  R30,R26
	OR   R0,R30
	__GETB1MN _BOX_piece,2
	LDD  R26,Y+4
	AND  R30,R26
	OR   R0,R30
	__GETB1MN _BOX_piece,3
	LDD  R26,Y+5
	AND  R30,R26
	OR   R30,R0
	BREQ _0x11E
;	{
;		//Conflict has been found
;		return 1;
	LDI  R30,LOW(1)
	RJMP _0x20C0011
;	}
;	else return 0;
_0x11E:
	LDI  R30,LOW(0)
;}
_0x20C0011:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,8
	RET
;
;void BOX_end_game(void)
;{
_BOX_end_game:
;  BOX_rewrite_display(white,black);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _BOX_rewrite_display
;
;  GLCD_string_sideways(1,54, message4, (sizeof(message4) / sizeof(message4[0])));
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(_message4*2)
	LDI  R31,HIGH(_message4*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	CALL _GLCD_string_sideways
;
;      while(1){
_0x120:
;       if (get_key_press(1<<BTN_EN)){
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x123
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       break;
	RJMP _0x122
;       }
;       if (get_key_press(1<<BTN_MD))
_0x123:
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x124
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x125
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x126
_0x125:
;                play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;       }
_0x126:
_0x124:
	RJMP _0x120
_0x122:
;
;    __PPPTT=0;
	CLR  R10
;  //while(1) { }
;}
	RET
;
;void BOX_write_piece(void)  //Writes piece to display
;{
_BOX_write_piece:
;    unsigned char i,j;
;  for (i=0; i<4; i++)  //Step through each of 4 columns
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R17,LOW(0)
_0x128:
	CPI  R17,4
	BRSH _0x129
;  {
;    for (j=0; j<4; j++) //Step through each of 4 rows
	LDI  R16,LOW(0)
_0x12B:
	CPI  R16,4
	BRSH _0x12C
;    {
;    //prevent invalid indices from being written
;      if ((y_loc-j) >= 0)
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	TST  R27
	BRMI _0x12D
;      {
;		if (BOX_piece[i] & 1<<j)
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_BOX_piece)
	SBCI R31,HIGH(-_BOX_piece)
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x12E
;		{
;		  //TODO: change this for different colored playing pieces
;		  BOX_draw(x_loc+i, y_loc-j, default_fg_color);
	MOV  R30,R17
	ADD  R30,R9
	ST   -Y,R30
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	ST   -Y,R26
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _BOX_draw
;		}
;      }
_0x12E:
;    }
_0x12D:
	SUBI R16,-1
	RJMP _0x12B
_0x12C:
;  }
	SUBI R17,-1
	RJMP _0x128
_0x129:
;}
	RJMP _0x20C0010
;
;void BOX_spawn(void)
;{
_BOX_spawn:
;  x_loc = 4;
	LDI  R30,LOW(4)
	MOV  R9,R30
;  y_loc = 1;
	LDI  R30,LOW(1)
	MOV  R12,R30
;  cur_piece = rnd(0,7);//random_piece;
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _rnd
	MOV  R11,R30
;  rotate = 0;
	CLR  R14
;
;  BOX_load_reference(cur_piece, rotate);  //load from reference
	ST   -Y,R11
	ST   -Y,R14
	RCALL _BOX_load_reference
;
;
;
;  //Check to see if we've filled the screen
;  if (BOX_check(0,0))
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _BOX_check
	CPI  R30,0
	BREQ _0x12F
;  {
;	  BOX_end_game();
	RCALL _BOX_end_game
;  }
;
;
;  BOX_store_loc(); //Store new location
_0x12F:
	RJMP _0x20C000C
;  BOX_write_piece(); //draw piece
;
;}
;
;void BOX_start_game(void)
;{
_BOX_start_game:
;
;  //Populate BOX_location[] with 0
;  unsigned char i;
;  unsigned char j;
;
;  for (i=0; i<array_size; i++) { BOX_location[i] = 0x00; }
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R17,LOW(0)
_0x131:
	CPI  R17,36
	BRSH _0x132
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_BOX_location)
	SBCI R31,HIGH(-_BOX_location)
	LDI  R26,LOW(0)
	STD  Z+0,R26
	SUBI R17,-1
	RJMP _0x131
_0x132:
;
;  //Draw frame around playing area
;
;  //Page 0
;  GLCD_GoTo(0,0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	CALL _ks0108_gotoxy
;  for (i=0; i<3; i++) 		//0-5
	LDI  R17,LOW(0)
_0x134:
	CPI  R17,3
	BRSH _0x135
;  {
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x134
_0x135:
;  GLCD_WriteData(0xAA); 	//6
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;  for (i=0; i<45; i++) 		//7-97
	LDI  R17,LOW(0)
_0x137:
	CPI  R17,45
	BRSH _0x138
;  {
;	  GLCD_WriteData(0xD5);
	LDI  R30,LOW(213)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x137
_0x138:
;  for (i=0; i<5; i++)		//98-106
	LDI  R17,LOW(0)
_0x13A:
	CPI  R17,5
	BRSH _0x13B
;  {
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x13A
_0x13B:
;  GLCD_WriteData(0x55);		//107
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;  for (i=0; i<5; i++)		//108-118
	LDI  R17,LOW(0)
_0x13D:
	CPI  R17,5
	BRSH _0x13E
;  {
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xD5);
	LDI  R30,LOW(213)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x13D
_0x13E:
;  for (i=0; i<5; i++)		//119-127
	LDI  R17,LOW(0)
_0x140:
	CPI  R17,5
	BRSH _0x141
;  {
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x140
_0x141:
;
;  //Page 1-6
;  for (j=1; j<7; j++)
	LDI  R16,LOW(1)
_0x143:
	CPI  R16,7
	BRLO PC+3
	JMP _0x144
;  {
;	  GLCD_GoTo(0,j);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R16
	CALL _ks0108_gotoxy
;	  for (i=0; i<3; i++)
	LDI  R17,LOW(0)
_0x146:
	CPI  R17,3
	BRSH _0x147
;	  {
;		  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;		  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;	  }
	SUBI R17,-1
	RJMP _0x146
_0x147:
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xFF);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_GoTo(96,j);
	LDI  R30,LOW(96)
	ST   -Y,R30
	ST   -Y,R16
	CALL _ks0108_gotoxy
;	  GLCD_WriteData(0xFF);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;	  for (i=0; i<5; i++)
	LDI  R17,LOW(0)
_0x149:
	CPI  R17,5
	BRSH _0x14A
;	  {
;		  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;		  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  }
	SUBI R17,-1
	RJMP _0x149
_0x14A:
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xFF);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_GoTo(118,j);
	LDI  R30,LOW(118)
	ST   -Y,R30
	ST   -Y,R16
	CALL _ks0108_gotoxy
;	  GLCD_WriteData(0xFF);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;	  for (i=0; i<7; i++)		//119-127
	LDI  R17,LOW(0)
_0x14C:
	CPI  R17,7
	BRSH _0x14D
;	  {
;		  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;		  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  }
	SUBI R17,-1
	RJMP _0x14C
_0x14D:
;  }
	SUBI R16,-1
	RJMP _0x143
_0x144:
;
;  //Page 7
;  GLCD_GoTo(0,7);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;  for (i=0; i<3; i++)			//0-5
	LDI  R17,LOW(0)
_0x14F:
	CPI  R17,3
	BRSH _0x150
;  {
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x14F
_0x150:
;  GLCD_WriteData(0xAA);			//6
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;  for (i=0; i<45; i++)			//7-96
	LDI  R17,LOW(0)
_0x152:
	CPI  R17,45
	BRSH _0x153
;  {
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xAB);
	LDI  R30,LOW(171)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x152
_0x153:
;  for (i=0; i<5; i++)			//97-108
	LDI  R17,LOW(0)
_0x155:
	CPI  R17,5
	BRSH _0x156
;  {
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x155
_0x156:
;  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;  GLCD_WriteData(0xBF);			//109
	LDI  R30,LOW(191)
	ST   -Y,R30
	CALL _ks0108_Write
;  for (i=0; i<4; i++)			//110-117
	LDI  R17,LOW(0)
_0x158:
	CPI  R17,4
	BRSH _0x159
;  {
;	  GLCD_WriteData(0x50);
	LDI  R30,LOW(80)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xB0);
	LDI  R30,LOW(176)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x158
_0x159:
;  GLCD_WriteData(0x50);			//118
	LDI  R30,LOW(80)
	ST   -Y,R30
	CALL _ks0108_Write
;  GLCD_WriteData(0xBF);			//119
	LDI  R30,LOW(191)
	ST   -Y,R30
	CALL _ks0108_Write
;  for (i=0; i<4; i++)			//109-126
	LDI  R17,LOW(0)
_0x15B:
	CPI  R17,4
	BRSH _0x15C
;  {
;	  GLCD_WriteData(0x55);
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;	  GLCD_WriteData(0xAA);
	LDI  R30,LOW(170)
	ST   -Y,R30
	CALL _ks0108_Write
;  }
	SUBI R17,-1
	RJMP _0x15B
_0x15C:
;  GLCD_WriteData(0x55);			//127
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _ks0108_Write
;
;
;  score = 0; //Reset score
	CLR  R13
;  GLCD_string_sideways(1,110, message5, (sizeof(message5) / sizeof(message5[0])));
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(110)
	ST   -Y,R30
	LDI  R30,LOW(_message5*2)
	LDI  R31,HIGH(_message5*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _GLCD_string_sideways
;  BOX_update_score();
	RCALL _BOX_update_score
;
;  BOX_rewrite_display(black, white);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _BOX_rewrite_display
;  BOX_spawn();
	RCALL _BOX_spawn
;}
	RJMP _0x20C0010
;
;
;
;
;void BOX_clear_piece(void)  //Clears piece from display
;{
_BOX_clear_piece:
;unsigned char i,j;
;  for (i=0; i<4; i++)  //Step through each of 4 columns
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R17,LOW(0)
_0x15E:
	CPI  R17,4
	BRSH _0x15F
;  {
;    for (j=0; j<4; j++) //Step through each of 4 rows
	LDI  R16,LOW(0)
_0x161:
	CPI  R16,4
	BRSH _0x162
;    {
;    //prevent invalid indices from being written
;      if ((y_loc-j) >= 0)
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	TST  R27
	BRMI _0x163
;      {
;  		if (BOX_piece[i] & 1<<j)
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_BOX_piece)
	SBCI R31,HIGH(-_BOX_piece)
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x164
;  		{
;  		  //TODO: change this for different colored playing pieces
;  		  BOX_erase(x_loc+i, y_loc-j);
	MOV  R30,R17
	ADD  R30,R9
	ST   -Y,R30
	MOV  R26,R12
	CLR  R27
	MOV  R30,R16
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	ST   -Y,R26
	RCALL _BOX_erase
;  		}
;      }
_0x164:
;    }
_0x163:
	SUBI R16,-1
	RJMP _0x161
_0x162:
;  }
	SUBI R17,-1
	RJMP _0x15E
_0x15F:
;}
_0x20C0010:
	LD   R16,Y+
	LD   R17,Y+
	RET
;
;
;void BOX_rotate(unsigned char direction)
;{
_BOX_rotate:
;  //TODO: Allow for adjustments if rotation is prevented due to proximity
;   unsigned char new_rotate = rotate;
;
;  BOX_clear_loc(); //Clear current location so we don't have false compares
	ST   -Y,R17
;	direction -> Y+1
;	new_rotate -> R17
	MOV  R17,R14
	RCALL _BOX_clear_loc
;
;  //Load in the candidate rotation
;
;  if (++new_rotate > 3) new_rotate = 0;
	SUBI R17,-LOW(1)
	CPI  R17,4
	BRLO _0x165
	LDI  R17,LOW(0)
;  BOX_load_reference(cur_piece,new_rotate);
_0x165:
	ST   -Y,R11
	ST   -Y,R17
	RCALL _BOX_load_reference
;
;  //Check for overlaps
;  if (BOX_check(0, 0))
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _BOX_check
	CPI  R30,0
	BREQ _0x166
;  {
;	  //Overlap will be caused, restore piece settings and return
;	  BOX_load_reference(cur_piece, rotate);
	ST   -Y,R11
	ST   -Y,R14
	RCALL _BOX_load_reference
;	  BOX_store_loc();
	RCALL _BOX_store_loc
;	  return;
	RJMP _0x20C000E
;  }
;  //No overlap found, allow new rotation
;  else
_0x166:
;  {
;	  //Load the current rotation back in and clear the piece from display
;	  BOX_load_reference(cur_piece, rotate);
	ST   -Y,R11
	ST   -Y,R14
	RCALL _BOX_load_reference
;	  BOX_clear_piece();
	RCALL _BOX_clear_piece
;
;	  //Load new rotation, display, and save its location
;	  rotate = new_rotate;
	MOV  R14,R17
;	  BOX_load_reference(cur_piece, rotate);
	ST   -Y,R11
	ST   -Y,R14
	RCALL _BOX_load_reference
;
;	  BOX_store_loc();
	RCALL _BOX_store_loc
;	  BOX_write_piece();
	RCALL _BOX_write_piece
;  }
;}
_0x20C000E:
	LDD  R17,Y+0
_0x20C000F:
	ADIW R28,2
	RET
;
;
;
;
;
;
;void BOX_line_check(void)
;{
_BOX_line_check:
;  //TODO: Tweak this to enable scoring
;
;  //Check every line on the playing area for complete rows and record them in an array
;  unsigned char complete_lines[4];	//There will never be more than 4 complete rows
;  unsigned char temp_index = 0;		//Index for complete_lines[]
;  unsigned char board_rows;
;  unsigned char board_cols=0;
;  unsigned char read_from_row;
;  unsigned char write_to_row;
;  unsigned char rows_left_to_read,i;
;  unsigned char col;
;
;  for (board_rows=0; board_rows<=BOX_board_bottom; board_rows++)
	SBIW R28,6
	CALL __SAVELOCR6
;	complete_lines -> Y+8
;	temp_index -> R17
;	board_rows -> R16
;	board_cols -> R19
;	read_from_row -> R18
;	write_to_row -> R21
;	rows_left_to_read -> R20
;	i -> Y+7
;	col -> Y+6
	LDI  R17,0
	LDI  R19,0
	LDI  R16,LOW(0)
_0x169:
	CPI  R16,22
	BRSH _0x16A
;  {
;    board_cols=0;
	LDI  R19,LOW(0)
;    while ((board_cols<=BOX_board_right) && (BOX_loc_return_bit(board_cols,board_rows)))
_0x16B:
	CPI  R19,12
	BRSH _0x16E
	ST   -Y,R19
	ST   -Y,R16
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BRNE _0x16F
_0x16E:
	RJMP _0x16D
_0x16F:
;    {
;    	//Complete row found, record in complete_lines[]
;		if (board_cols == BOX_board_right) complete_lines[temp_index++] = board_rows;
	CPI  R19,11
	BRNE _0x170
	MOV  R30,R17
	SUBI R17,-1
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,8
	ADD  R30,R26
	ADC  R31,R27
	ST   Z,R16
;		++board_cols;
_0x170:
	SUBI R19,-LOW(1)
;    }
	RJMP _0x16B
_0x16D:
;  }
	SUBI R16,-1
	RJMP _0x169
_0x16A:
;  if (temp_index == 0) return;  //No complete lines found, return
	CPI  R17,0
	BRNE _0x171
	RJMP _0x20C000D
;
;
;  //If there are complete rows
;    //TODO: Disable interrupts to pause game flow
;    //TODO: Add an arbitrary delay, perhaps make complete lines flash?
;
;  score += temp_index; //Add the completed rows to our score
_0x171:
	ADD  R13,R17
;  paly_sound_key(tetris_one);
	LDI  R30,LOW(_tetris_one*2)
	LDI  R31,HIGH(_tetris_one*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;  if(overflow_t0>=30);
;  overflow_t0-=5;
	MOV  R30,R7
	LDI  R31,0
	SBIW R30,5
	MOV  R7,R30
;
;  --temp_index;	//This was incremented one too many times earlier, get it back to the proper index.
	SUBI R17,LOW(1)
;
;  //Rewrite BOX_location[] data without completed lines
;  read_from_row = BOX_board_bottom;
	LDI  R18,LOW(21)
;  write_to_row = BOX_board_bottom;
	LDI  R21,LOW(21)
;
;  //When we have read from all rows, this will be set to 0 and
;  //remaining bits cleared from BOX_location[]
;  rows_left_to_read = 1;
	LDI  R20,LOW(1)
;
;  //Use variable i to iterate through every row of the board
;  i=0;
	LDI  R30,LOW(0)
	STD  Y+7,R30
;  while (i <= BOX_board_bottom)
_0x173:
	LDD  R26,Y+7
	CPI  R26,LOW(0x16)
	BRSH _0x175
;  {
;	  //If the current row is a complete line
;	  if (read_from_row == complete_lines[temp_index])
	MOV  R30,R17
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,8
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	CP   R30,R18
	BRNE _0x176
;	  {
;		  //Decrement indexes
;		  if (read_from_row == 0)
	CPI  R18,0
	BRNE _0x177
;		  {
;			  rows_left_to_read = 0;
	LDI  R20,LOW(0)
;
;			  //Change complete_lines[0] so we don't do this again
;			  complete_lines[0] = BOX_board_bottom;
	LDI  R30,LOW(21)
	STD  Y+8,R30
;		  }
;		  else
	RJMP _0x178
_0x177:
;		  {
;			  --read_from_row;
	SUBI R18,LOW(1)
;			  if (temp_index) --temp_index;
	CPI  R17,0
	BREQ _0x179
	SUBI R17,LOW(1)
;		  }
_0x179:
_0x178:
;	  }
;
;	  else
	RJMP _0x17A
_0x176:
;	  {
;		  //Write data to all columns of current row
;		  for (col=0; col<=BOX_board_right; col++)
	LDI  R30,LOW(0)
	STD  Y+6,R30
_0x17C:
	LDD  R26,Y+6
	CPI  R26,LOW(0xC)
	BRSH _0x17D
;		  {
;			  //If there are rows left to read from, do so.
;			  if (rows_left_to_read)
	CPI  R20,0
	BREQ _0x17E
;			  {
;				  if (BOX_loc_return_bit(col,read_from_row)) BOX_loc_set_bit(col, write_to_row);
	LDD  R30,Y+6
	ST   -Y,R30
	ST   -Y,R18
	RCALL _BOX_loc_return_bit
	CPI  R30,0
	BREQ _0x17F
	LDD  R30,Y+6
	ST   -Y,R30
	ST   -Y,R21
	RCALL _BOX_loc_set_bit
;				  else BOX_loc_clear_bit(col, write_to_row);
	RJMP _0x180
_0x17F:
	LDD  R30,Y+6
	ST   -Y,R30
	ST   -Y,R21
	RCALL _BOX_loc_clear_bit
;			  }
_0x180:
;			  //There are no rows left to read from, fill with 0
;			  else
	RJMP _0x181
_0x17E:
;			  {
;				  BOX_loc_clear_bit(col, write_to_row);
	LDD  R30,Y+6
	ST   -Y,R30
	ST   -Y,R21
	RCALL _BOX_loc_clear_bit
;			  }
_0x181:
;		  }
	LDD  R30,Y+6
	SUBI R30,-LOW(1)
	STD  Y+6,R30
	RJMP _0x17C
_0x17D:
;
;		  //A row has now been read from, decrement the counter
;		  --read_from_row;
	SUBI R18,LOW(1)
;
;		  //A row has now been written to, increment the counter, decrement the tracker
;		  ++i;
	LDD  R30,Y+7
	SUBI R30,-LOW(1)
	STD  Y+7,R30
;		  --write_to_row;
	SUBI R21,LOW(1)
;	  }
_0x17A:
;  }
	RJMP _0x173
_0x175:
;
;  BOX_rewrite_display(black, white);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _BOX_rewrite_display
;  BOX_update_score();
	RCALL _BOX_update_score
;}
_0x20C000D:
	CALL __LOADLOCR6
	ADIW R28,12
	RET
;
;
;void BOX_up(void)
;{
;  BOX_clear_loc();
;  BOX_clear_piece();
;
;  if (++cur_piece > 6) cur_piece = 0;
;  x_loc = 4;
;  y_loc = 0;
;
;  BOX_spawn();
;}
;
;void BOX_dn(void)
;{
_BOX_dn:
;  if (BOX_check(0, 1))
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _BOX_check
	CPI  R30,0
	BREQ _0x183
;  {
;    //Set piece here and spawn a new one
;    BOX_rewrite_display(black, default_bg_color);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _BOX_rewrite_display
;    BOX_line_check();
	RCALL _BOX_line_check
;    BOX_spawn();
	RCALL _BOX_spawn
;    return;
	RET
;  }
;
;  BOX_clear_loc();
_0x183:
	RCALL _BOX_clear_loc
;  BOX_clear_piece();
	RCALL _BOX_clear_piece
;  ++y_loc;
	INC  R12
;
;  BOX_store_loc();
	RJMP _0x20C000C
;  BOX_write_piece();
;}
;
;void BOX_lt(void)
;{
_BOX_lt:
;  if (BOX_check(-1, 0)) return; //Do nothing if moving causes an overlap
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _BOX_check
	CPI  R30,0
	BREQ _0x184
	RET
;  BOX_clear_loc();
_0x184:
	RCALL _BOX_clear_loc
;  BOX_clear_piece();
	RCALL _BOX_clear_piece
;  x_loc--;
	DEC  R9
;
;  BOX_store_loc();
	RJMP _0x20C000C
;  BOX_write_piece();
;}
;
;void BOX_rt(void)
;{
_BOX_rt:
;  if (BOX_check(1, 0)) return; //Do nothing if moving causes an overlap
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _BOX_check
	CPI  R30,0
	BREQ _0x185
	RET
;  BOX_clear_loc();
_0x185:
	RCALL _BOX_clear_loc
;  BOX_clear_piece();
	RCALL _BOX_clear_piece
;  ++x_loc;
	INC  R9
;
;  BOX_store_loc();
_0x20C000C:
	RCALL _BOX_store_loc
;  BOX_write_piece();
	RCALL _BOX_write_piece
;}
	RET
;
;void Run_tetris(void){
_Run_tetris:
;
;overflow_t0=100; // For 1 secend
	LDI  R30,LOW(100)
	MOV  R7,R30
;ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;
;  GLCD_GoTo(40,4);
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;  GLCD_string_sideways(0,88,message1, (sizeof(message1) / sizeof(message1[0])));
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(88)
	ST   -Y,R30
	LDI  R30,LOW(_message1*2)
	LDI  R31,HIGH(_message1*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(20)
	ST   -Y,R30
	CALL _GLCD_string_sideways
;  GLCD_string_sideways(0,52,message2, (sizeof(message2) / sizeof(message2[0])));
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(52)
	ST   -Y,R30
	LDI  R30,LOW(_message2*2)
	LDI  R31,HIGH(_message2*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(11)
	ST   -Y,R30
	CALL _GLCD_string_sideways
;  GLCD_string_sideways(0,44,message3, (sizeof(message3) / sizeof(message3[0])));
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(44)
	ST   -Y,R30
	LDI  R30,LOW(_message3*2)
	LDI  R31,HIGH(_message3*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	CALL _GLCD_string_sideways
;light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
;play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;while(get_key_press(1<<BTN_EN) == 0){
_0x186:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE _0x188
;      if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x189
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x18A
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x18B
_0x18A:
;                play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;      if (get_key_press(1<<BTN_ES)){
_0x18B:
_0x189:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x18C
;        light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;        return;
	RET
;        }
;}
_0x18C:
	RJMP _0x186
_0x188:
;light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;BOX_start_game();
	RCALL _BOX_start_game
;light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
;__PPPTT=1;
	LDI  R30,LOW(1)
	MOV  R10,R30
;while (__PPPTT)
_0x18D:
	TST  R10
	BRNE PC+3
	JMP _0x18F
;      {
;          if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x190
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x191
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x192
_0x191:
;                play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;    if (get_key_press(1<<BTN_UP)!=0)
_0x192:
_0x190:
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x193
;    {
;      paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      BOX_rotate(1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _BOX_rotate
;    }
;
;    if (get_key_press(1<<BTN_DN))
_0x193:
	LDI  R30,LOW(8)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x194
;    {
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      BOX_dn();
	RCALL _BOX_dn
;    }
;
;    if (get_key_press(1<<BTN_LT)) {
_0x194:
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x195
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      BOX_lt();
	RCALL _BOX_lt
;    }
;
;    if (get_key_press(1<<BTN_RT))
_0x195:
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x196
;    {
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      BOX_rt();
	RCALL _BOX_rt
;    }
;
;    if (get_key_press(1<<BTN_EN))
_0x196:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x197
;    {
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      BOX_rotate(1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _BOX_rotate
;    }
;
;    if (drop_timer_flag)
_0x197:
	LDS  R30,_drop_timer_flag_G000
	CPI  R30,0
	BREQ _0x198
;    {
;      drop_timer_flag = 0;
	LDI  R30,LOW(0)
	STS  _drop_timer_flag_G000,R30
;      BOX_dn();
	RCALL _BOX_dn
;    }
;
;    if (get_key_press(1<<BTN_ES)){
_0x198:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x199
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;        break;
	RJMP _0x18F
;        }
;
;      };
_0x199:
	RJMP _0x18D
_0x18F:
;
;
;}
	RET
;#include "game's/puzzle.c"
;#define UP 0
;#define DOWN 1
;#define LEFT 2
;#define RIGHT 3
;#define RESET 4
;#define NONE 5
;
;
;flash char PIC1_BMP[1024] = {
;
;0x00,0xFC,0xFE,0xFE,0xFE,0x1E,0x0E,0xCE,0x0E,0x1E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x7E,0x1E,0x0E,0x0E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0x3E,0x0E,0x4E,0x4E,0xCE,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0x1E,0x0E,0x4E,0x4E,0xDE,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x9E,0x9E,0x9E,0x1E,0x9E,0xFE,0xFE,0xFE,0xFC,0x00,
;0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x73,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x79,0x71,0x73,0x70,0x78,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x78,0x79,0x70,0x70,0x79,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7A,0x72,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x63,0x60,0x7C,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,
;0x00,0xFC,0xFE,0xFE,0xFE,0x9E,0x0E,0x4E,0x0E,0x9E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x1E,0x0E,0x4E,0x0E,0x1E,0xFE,0xFE,0xFE,0xFC,0x00,0x00,0xFC,0x9E,0xCE,0x06,0x06,0xFE,0xFE,0xFE,0x0E,0x06,0xE6,0x06,0x0E,0xFC,0x00,0x00,0xFC,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x3E,0x9E,0x0E,0x0E,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x7E,0x1E,0x0E,0x0E,0xFE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0x3E,0x0E,0x4E,0x4E,0xCE,0xFE,0xFC,0x00,
;0x00,0x3F,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x7F,0x7B,0x72,0x72,0x70,0x78,0x7F,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x78,0x78,0x7F,0x7F,0x7F,0x7C,0x78,0x79,0x78,0x7C,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x70,0x70,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x73,0x71,0x70,0x72,0x73,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x79,0x71,0x73,0x70,0x78,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x78,0x78,0x79,0x70,0x70,0x79,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7A,0x72,0x72,0x70,0x78,0x7F,0x3F,0x00,
;0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x1E,0x0E,0x4E,0x4E,0xDE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xCE,0xCE,0x4E,0x0E,0xCE,0xFE,0xFC,0x00,0x00,0xFC,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0xFE,0x9E,0x0E,0x4E,0x0E,0x9E,0xFC,0x00,0x00,0xFC,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFE,0x1E,0x0E,0x4E,0x0E,0x1E,0xFC,0x00,0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x1E,0x0E,0xCE,0x0E,0x1E,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x3E,0x9E,0x0E,0x0E,0xFE,0xFC,0x00,0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFC,0x00,
;0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x71,0x70,0x7E,0x7F,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x7F,0x7B,0x72,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x70,0x73,0x70,0x78,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x7F,0x70,0x70,0x7F,0x3F,0x00,0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x79,0x71,0x73,0x70,0x78,0x3F,0x00,
;0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFE,0x7E,0x1E,0x0E,0x0E,0xFE,0xFC,0x00,0x00,0xFC,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xFE,0x3E,0x0E,0x4E,0x4E,0xCE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x1E,0x0E,0x4E,0x4E,0xDE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0xCE,0xCE,0x4E,0x0E,0xCE,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x9E,0x0E,0x4E,0x0E,0x9E,0xFC,0x00,0x00,0xFC,0xFE,0x9E,0x8E,0xCE,0x0E,0x1E,0xFE,0x1E,0x0E,0x4E,0x0E,0x1E,0xFC,0x00,0x00,0xFC,0xFE,0xDE,0xCE,0x4E,0x0E,0x9E,0xFE,0x1E,0x0E,0xCE,0x0E,0x1E,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x78,0x79,0x70,0x70,0x79,0x3F,0x00,0x00,0x3F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x7A,0x72,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7F,0x71,0x70,0x7E,0x7F,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x78,0x70,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x73,0x71,0x70,0x72,0x73,0x7F,0x7B,0x72,0x72,0x70,0x78,0x3F,0x00,0x00,0x3F,0x7F,0x79,0x71,0x73,0x70,0x78,0x7F,0x78,0x70,0x73,0x70,0x78,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;};
;
;
;
;unsigned char image_part[32];
;unsigned char homes[32];		//location of every part sorted by ids
;unsigned char empty_id = 31;

	.DSEG
;flash char *pic;
;
;
;void glcd_drawImage(char *_pic,char x, char y){
; 0000 0028 void glcd_drawImage(char *_pic,char x, char y){

	.CSEG
_glcd_drawImage:
;
;char  i,j;
;
;
;    for(j=0;j<2;j++){
	ST   -Y,R17
	ST   -Y,R16
;	*_pic -> Y+4
;	x -> Y+3
;	y -> Y+2
;	i -> R17
;	j -> R16
	LDI  R16,LOW(0)
_0x19C:
	CPI  R16,2
	BRSH _0x19D
;        ks0108_gotoxy(0+x,j+y);;
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	ADD  R30,R16
	ST   -Y,R30
	CALL _ks0108_gotoxy
;    for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x19F:
	CPI  R17,16
	BRSH _0x1A0
;        {
;        ks0108_Write(_pic[j*16+i]);
	LDI  R30,LOW(16)
	MULS R30,R16
	MOVW R30,R0
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	ST   -Y,R30
	CALL _ks0108_Write
;            }
	SUBI R17,-1
	RJMP _0x19F
_0x1A0:
;  }
	SUBI R16,-1
	RJMP _0x19C
_0x19D:
;
;}
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,6
	RET
;//this methode cut 16*16 pixel from image and
;//copy it to image_part
;void cut_part(flash char *pic , unsigned char id)
;{
_cut_part:
;	unsigned char i , j;
;	unsigned char *ptr = image_part;
;
;	if(id == 31)
	CALL __SAVELOCR4
;	*pic -> Y+5
;	id -> Y+4
;	i -> R17
;	j -> R16
;	*ptr -> R18,R19
	__POINTWRM 18,19,_image_part
	LDD  R26,Y+4
	CPI  R26,LOW(0x1F)
	BRNE _0x1A1
;	{
;		for(i = 0; i < 32; i++ , ptr++)
	LDI  R17,LOW(0)
_0x1A3:
	CPI  R17,32
	BRSH _0x1A4
;			*ptr = 0;
	MOVW R26,R18
	LDI  R30,LOW(0)
	ST   X,R30
	SUBI R17,-1
	__ADDWRN 18,19,1
	RJMP _0x1A3
_0x1A4:
	RJMP _0x20C000B
;	}
;
;	pic += ((id%8)*16) + ((id/8)*256);
_0x1A1:
	LDD  R26,Y+4
	CLR  R27
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MODW21
	CALL __LSLW4
	MOVW R22,R30
	LDD  R26,Y+4
	LDI  R27,0
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __DIVW21
	MOV  R31,R30
	LDI  R30,0
	ADD  R30,R22
	ADC  R31,R23
	LDD  R26,Y+5
	LDD  R27,Y+5+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+5,R30
	STD  Y+5+1,R31
;	for(i = 0; i != 2 ; i++)
	LDI  R17,LOW(0)
_0x1A6:
	CPI  R17,2
	BREQ _0x1A7
;	{
;		for(j = 0; j != 16; j++)
	LDI  R16,LOW(0)
_0x1A9:
	CPI  R16,16
	BREQ _0x1AA
;		{
;			*ptr = *(pic);
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	LPM  R30,Z
	MOVW R26,R18
	ST   X,R30
;			ptr++;
	__ADDWRN 18,19,1
;			pic++;
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ADIW R30,1
	STD  Y+5,R30
	STD  Y+5+1,R31
;		}
	SUBI R16,-1
	RJMP _0x1A9
_0x1AA:
;
;		pic += 128-16;
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	SUBI R30,LOW(-112)
	SBCI R31,HIGH(-112)
	STD  Y+5,R30
	STD  Y+5+1,R31
;	}
	SUBI R17,-1
	RJMP _0x1A6
_0x1A7:
;}
_0x20C000B:
	CALL __LOADLOCR4
	ADIW R28,7
	RET
;
;void draw_part(unsigned char id)
;{
_draw_part:
;	unsigned char x , y;
;
;	x = ((id%8) * 16);
	ST   -Y,R17
	ST   -Y,R16
;	id -> Y+2
;	x -> R17
;	y -> R16
	LDD  R26,Y+2
	CLR  R27
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MODW21
	LDI  R26,LOW(16)
	MULS R30,R26
	MOV  R17,R0
;	y = (id/8) * 2;
	LDD  R26,Y+2
	LDI  R27,0
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __DIVW21
	LSL  R30
	MOV  R16,R30
;	glcd_drawImage(image_part , x , y);
	LDI  R30,LOW(_image_part)
	LDI  R31,HIGH(_image_part)
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	RCALL _glcd_drawImage
;}
	RJMP _0x20C000A
;
;void draw_all()
;{
_draw_all:
;	unsigned char i;
;	for(i = 0; i < 32 ; i++)
	ST   -Y,R17
;	i -> R17
	LDI  R17,LOW(0)
_0x1AC:
	CPI  R17,32
	BRSH _0x1AD
;	{
;		cut_part( pic , homes[i] );
	LDS  R30,_pic
	LDS  R31,_pic+1
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	LD   R30,Z
	ST   -Y,R30
	RCALL _cut_part
;		draw_part( i );
	ST   -Y,R17
	RCALL _draw_part
;	}
	SUBI R17,-1
	RJMP _0x1AC
_0x1AD:
;}
	LD   R17,Y+
	RET
;
;//this method move home
;char move(unsigned char side)
;{
_move:
;	unsigned char x ,y;
;	x = empty_id%8;
	ST   -Y,R17
	ST   -Y,R16
;	side -> Y+2
;	x -> R17
;	y -> R16
	LDS  R26,_empty_id
	CLR  R27
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MODW21
	MOV  R17,R30
;	y = empty_id/8;
	LDS  R26,_empty_id
	LDI  R27,0
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __DIVW21
	MOV  R16,R30
;	switch(side)
	LDD  R30,Y+2
	LDI  R31,0
;	{
;		case DOWN:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x1B1
;			if(y > 0)
	CPI  R16,1
	BRLO _0x1B2
;				y--;
	SUBI R16,1
;			else
	RJMP _0x1B3
_0x1B2:
;				return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C000A
;			break;
_0x1B3:
	RJMP _0x1B0
;		case UP:
_0x1B1:
	SBIW R30,0
	BRNE _0x1B4
;			if(y < 3)
	CPI  R16,3
	BRSH _0x1B5
;				y++;
	SUBI R16,-1
;			else
	RJMP _0x1B6
_0x1B5:
;				return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C000A
;			break;
_0x1B6:
	RJMP _0x1B0
;		case RIGHT:
_0x1B4:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x1B7
;			if(x > 0)
	CPI  R17,1
	BRLO _0x1B8
;				x--;
	SUBI R17,1
;			else
	RJMP _0x1B9
_0x1B8:
;				return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C000A
;			break;
_0x1B9:
	RJMP _0x1B0
;		case LEFT:
_0x1B7:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x1B0
;			if(x < 7)
	CPI  R17,7
	BRSH _0x1BB
;				x++;
	SUBI R17,-1
;			else
	RJMP _0x1BC
_0x1BB:
;				return 0;
	LDI  R30,LOW(0)
	RJMP _0x20C000A
;	}
_0x1BC:
_0x1B0:
;
;	homes[ empty_id ] = homes[ x + (y*8) ];
	LDS  R30,_empty_id
	LDI  R31,0
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	MOVW R22,R30
	MOV  R26,R17
	CLR  R27
	LDI  R30,LOW(8)
	MULS R30,R16
	MOVW R30,R0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	LD   R30,Z
	MOVW R26,R22
	ST   X,R30
;	homes[ x + (y*8) ] = 31;
	MOV  R26,R17
	CLR  R27
	LDI  R30,LOW(8)
	MULS R30,R16
	MOVW R30,R0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	LDI  R26,LOW(31)
	STD  Z+0,R26
;	empty_id = x + (y*8);
	MOV  R30,R16
	LSL  R30
	LSL  R30
	LSL  R30
	ADD  R30,R17
	STS  _empty_id,R30
;	draw_all();
	RCALL _draw_all
;	return 1;
	LDI  R30,LOW(1)
_0x20C000A:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,3
	RET
;}
;
;
;
;void beham(void)
;{
_beham:
;	unsigned char i , t ,last=10;
;	for( i = 0; i < 32; i++)
	CALL __SAVELOCR4
;	i -> R17
;	t -> R16
;	last -> R19
	LDI  R19,10
	LDI  R17,LOW(0)
_0x1BE:
	CPI  R17,32
	BRSH _0x1BF
;		homes[i] = i;
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	ST   Z,R17
	SUBI R17,-1
	RJMP _0x1BE
_0x1BF:
	RCALL _draw_all
;
;	for( i = 0 ; i != 0xff; )
	LDI  R17,LOW(0)
_0x1C1:
	CPI  R17,255
	BREQ _0x1C2
;	{
;		t = rnd(0,4);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _rnd
	MOV  R16,R30
;		if( (t == UP && last != DOWN) ||
;			(t == DOWN && last != UP) ||
;			(t == LEFT && last != RIGHT) ||
;			(t == RIGHT && last != LEFT) )
	CPI  R16,0
	BRNE _0x1C4
	CPI  R19,1
	BRNE _0x1C6
_0x1C4:
	CPI  R16,1
	BRNE _0x1C7
	CPI  R19,0
	BRNE _0x1C6
_0x1C7:
	CPI  R16,2
	BRNE _0x1C9
	CPI  R19,3
	BRNE _0x1C6
_0x1C9:
	CPI  R16,3
	BRNE _0x1CB
	CPI  R19,2
	BRNE _0x1C6
_0x1CB:
	RJMP _0x1C3
_0x1C6:
;		{
;			move( t );
	ST   -Y,R16
	RCALL _move
;			i++;
	SUBI R17,-1
;			last = t;
	MOV  R19,R16
;		}
;	}
_0x1C3:
	RJMP _0x1C1
_0x1C2:
;
;
;}
	RJMP _0x20C0008
;
;char win_puzzle(void){
_win_puzzle:
;
;char i,valid=1;
;
;for( i = 0; i < 32; i++)
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	valid -> R16
	LDI  R16,1
	LDI  R17,LOW(0)
_0x1CF:
	CPI  R17,32
	BRSH _0x1D0
;        if(homes[i] != i)
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	LD   R26,Z
	CP   R17,R26
	BREQ _0x1D1
;           valid=0;
	LDI  R16,LOW(0)
;
;if(valid==1){        //when Win
_0x1D1:
	SUBI R17,-1
	RJMP _0x1CF
_0x1D0:
	CPI  R16,1
	BRNE _0x1D2
;ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;lputsf(7,0,"You Won The Game!");
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	__POINTW1FN _0x0,86
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;lputsf(7,2,"For New Game Press");
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__POINTW1FN _0x0,15
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;lputsf(40,3,"<-ENTER->");
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__POINTW1FN _0x0,34
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;lputsf(5,5,"Or Esc To Exit Game.");
	LDI  R30,LOW(5)
	ST   -Y,R30
	ST   -Y,R30
	__POINTW1FN _0x0,44
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;}
;return valid;
_0x1D2:
	MOV  R30,R16
	JMP  _0x20C0005
;}
;
;void run_puzzle(void){
_run_puzzle:
;
;	unsigned char i ;
;
;start:
	ST   -Y,R17
;	i -> R17
_0x1D3:
;pic = PIC1_BMP;
	LDI  R30,LOW(_PIC1_BMP*2)
	LDI  R31,HIGH(_PIC1_BMP*2)
	STS  _pic,R30
	STS  _pic+1,R31
;play_sound(puzzle_sound);
	LDI  R30,LOW(_puzzle_sound*2)
	LDI  R31,HIGH(_puzzle_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;for( i = 0; i < 32; i++)
	LDI  R17,LOW(0)
_0x1D5:
	CPI  R17,32
	BRSH _0x1D6
;        homes[i] = i;
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_homes)
	SBCI R31,HIGH(-_homes)
	ST   Z,R17
	SUBI R17,-1
	RJMP _0x1D5
_0x1D6:
	LDI  R30,LOW(31)
	STS  _empty_id,R30
; draw_all();
	RCALL _draw_all
;light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
;while(get_key_press(1<<BTN_EN) == 0){
_0x1D7:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE _0x1D9
;      if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1DA
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x1DB
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x1DC
_0x1DB:
;                play_sound(puzzle_sound);
	LDI  R30,LOW(_puzzle_sound*2)
	LDI  R31,HIGH(_puzzle_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;          if (get_key_press(1<<BTN_ES)){
_0x1DC:
_0x1DA:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1DD
;          light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;                return;
	JMP  _0x20C0006
;        }
;}
_0x1DD:
	RJMP _0x1D7
_0x1D9:
;beham();
	RCALL _beham
;
;while(1){
_0x1DE:
;
;      if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1E1
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x1E2
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x1E3
_0x1E2:
;                play_sound(puzzle_sound);
	LDI  R30,LOW(_puzzle_sound*2)
	LDI  R31,HIGH(_puzzle_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;    if (get_key_press(1<<BTN_UP)!=0)
_0x1E3:
_0x1E1:
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1E4
;    {
;      paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      move(UP);
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _move
;    }
;
;    if (get_key_press(1<<BTN_DN))
_0x1E4:
	LDI  R30,LOW(8)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1E5
;    {
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      move(DOWN);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _move
;    }
;
;    if (get_key_press(1<<BTN_LT)) {
_0x1E5:
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1E6
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      move(LEFT);
	LDI  R30,LOW(2)
	ST   -Y,R30
	RCALL _move
;    }
;
;    if (get_key_press(1<<BTN_RT))
_0x1E6:
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1E7
;    {
;    paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;      move(RIGHT);
	LDI  R30,LOW(3)
	ST   -Y,R30
	RCALL _move
;    }
;
;
;    if (get_key_press(1<<BTN_ES)){
_0x1E7:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1E8
;        light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;        break;
	RJMP _0x1E0
;        }
;
;   if(win_puzzle()==1){
_0x1E8:
	RCALL _win_puzzle
	CPI  R30,LOW(0x1)
	BRNE _0x1E9
;    while(1){
_0x1EA:
;
;
;       if (get_key_press(1<<BTN_EN)){
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1ED
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       goto start;
	RJMP _0x1D3
;       }
;
;        if (get_key_press(1<<BTN_ES)){
_0x1ED:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x1EE
;       paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;       return;
	JMP  _0x20C0006
;       }
;    }
_0x1EE:
	RJMP _0x1EA
;
;   }
;}
_0x1E9:
	RJMP _0x1DE
_0x1E0:
;
;}
	JMP  _0x20C0006
;
;#include "game's/breakout.c"
;//
;
;
;flash char pblock[]={0x00,0x3C,0x76,0x6A,0x56,0x6A,0x56,0x6A,0x56,0x6A,0x56,0x6A,0x56,0x6E,0x3C,0x00};
;
;flash char prackt[]={
;129,195,0xE7,0xEF,0xF7,0xEF,0xF7,0xEF,0xF7,0xEF,0xF7,0xEF,0xF7,0xE7,195,129,
;129,194,0xE7,0xEE,0xF7,0xEE,0xF7,0xEE,0xF7,0xEE,0xF7,0xEE,0xF7,0xE6,195,129
;};
;
;flash char pball[]={0x3C,0x7E,0xFF,0xFF,0xDF,0xCF,0x7E,0x3C};
;flash char plevels[]={
;0xAA,~0xAA,0x00,0x00,
;0xAA,0xFF,0x00,0x00,
;0xFF,195,0x00,0x00,
;0x55,0xAA,0x55,0x00,
;0xE7,195,0xFF,0x00,
;0xFF,~195,0xFF,0x00,
;0xFF,0x55,0xFF,0x00,
;0xFF,0xDB,0x92,0x00,
;0xAA,0x55,0xaa,0xFF,
;0xFF,0xFF,0xFF,0xFF
;};
;
;
;char block[4];
;
;void load_level(char lev){
; 0000 0029 void load_level(char lev){
_load_level:
; char i;
;    for(i=0;i<4;i++)
	ST   -Y,R17
;	lev -> Y+1
;	i -> R17
	LDI  R17,LOW(0)
_0x1F0:
	CPI  R17,4
	BRSH _0x1F1
;        block[i]=plevels[i+lev*4];
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_block)
	SBCI R31,HIGH(-_block)
	MOVW R24,R30
	MOV  R22,R17
	CLR  R23
	LDD  R26,Y+1
	LDI  R30,LOW(4)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-_plevels*2)
	SBCI R31,HIGH(-_plevels*2)
	LPM  R30,Z
	MOVW R26,R24
	ST   X,R30
	SUBI R17,-1
	RJMP _0x1F0
_0x1F1:
	LDD  R17,Y+0
	JMP  _0x20C0003
;
;char Win_Game(void){
_Win_Game:
;char temp=0;
;    temp +=block[0];
	ST   -Y,R17
;	temp -> R17
	LDI  R17,0
	LDS  R30,_block
	ADD  R17,R30
;    temp +=block[1];
	__GETB1MN _block,1
	ADD  R17,R30
;    temp +=block[2];
	__GETB1MN _block,2
	ADD  R17,R30
;    temp +=block[3];
	__GETB1MN _block,3
	ADD  R17,R30
;    return (temp==0)? 1:0;
	CPI  R17,0
	BRNE _0x1F2
	LDI  R30,LOW(1)
	RJMP _0x1F3
_0x1F2:
	LDI  R30,LOW(0)
_0x1F3:
	JMP  _0x20C0006
;}
;
;void show_ball(char x, char y,char color){
_show_ball:
;
;char i;
;ks0108_gotoxy(x*8,y);
	ST   -Y,R17
;	x -> Y+3
;	y -> Y+2
;	color -> Y+1
;	i -> R17
	LDD  R30,Y+3
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _ks0108_gotoxy
;for(i=0;i<8;i++)
	LDI  R17,LOW(0)
_0x1F6:
	CPI  R17,8
	BRSH _0x1F7
;     if(color==1)
	LDD  R26,Y+1
	CPI  R26,LOW(0x1)
	BRNE _0x1F8
;        ks0108_Write(pball[i]);
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_pball*2)
	SBCI R31,HIGH(-_pball*2)
	LPM  R30,Z
	RJMP _0x27A
;     else
_0x1F8:
;        ks0108_Write(0);
	LDI  R30,LOW(0)
_0x27A:
	ST   -Y,R30
	CALL _ks0108_Write
;}
	SUBI R17,-1
	RJMP _0x1F6
_0x1F7:
	LDD  R17,Y+0
	RJMP _0x20C0007
;
;void show_rocket(char x,char soor ,char color){
_show_rocket:
;char i;
;ks0108_gotoxy(x*8,7);
	ST   -Y,R17
;	x -> Y+3
;	soor -> Y+2
;	color -> Y+1
;	i -> R17
	LDD  R30,Y+3
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x1FB:
	CPI  R17,16
	BRSH _0x1FC
;     if(color==1)
	LDD  R26,Y+1
	CPI  R26,LOW(0x1)
	BRNE _0x1FD
;        ks0108_Write(prackt[i+(soor*16)]);
	MOV  R22,R17
	CLR  R23
	LDD  R26,Y+2
	LDI  R30,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	ADD  R30,R22
	ADC  R31,R23
	SUBI R30,LOW(-_prackt*2)
	SBCI R31,HIGH(-_prackt*2)
	LPM  R30,Z
	RJMP _0x27B
;     else
_0x1FD:
;        ks0108_Write(0);
	LDI  R30,LOW(0)
_0x27B:
	ST   -Y,R30
	CALL _ks0108_Write
;}
	SUBI R17,-1
	RJMP _0x1FB
_0x1FC:
	LDD  R17,Y+0
	RJMP _0x20C0007
;
;void show_block(char x,char y, char color){
_show_block:
;char i;
;ks0108_gotoxy(x,y);
	ST   -Y,R17
;	x -> Y+3
;	y -> Y+2
;	color -> Y+1
;	i -> R17
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _ks0108_gotoxy
;for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x200:
	CPI  R17,16
	BRSH _0x201
;     if(color==1)
	LDD  R26,Y+1
	CPI  R26,LOW(0x1)
	BRNE _0x202
;        ks0108_Write(pblock[i]);
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_pblock*2)
	SBCI R31,HIGH(-_pblock*2)
	LPM  R30,Z
	RJMP _0x27C
;     else
_0x202:
;        ks0108_Write(0);
	LDI  R30,LOW(0)
_0x27C:
	ST   -Y,R30
	CALL _ks0108_Write
;}
	SUBI R17,-1
	RJMP _0x200
_0x201:
	LDD  R17,Y+0
	RJMP _0x20C0007
;
;void show_all_block(void){
_show_all_block:
;char i,j;
;
;for(i=0;i<4;i++){
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R17,LOW(0)
_0x205:
	CPI  R17,4
	BRSH _0x206
;ks0108_gotoxy(0,i);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R17
	CALL _ks0108_gotoxy
;    for(j=0;j<8;j++)
	LDI  R16,LOW(0)
_0x208:
	CPI  R16,8
	BRSH _0x209
;     if((block[i]&1<<j)!=0)
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_block)
	SBCI R31,HIGH(-_block)
	LD   R1,Z
	MOV  R30,R16
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x20A
;         show_block(j*16,i, 1);
	LDI  R26,LOW(16)
	MULS R16,R26
	ST   -Y,R0
	ST   -Y,R17
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_block
;}
_0x20A:
	SUBI R16,-1
	RJMP _0x208
_0x209:
	SUBI R17,-1
	RJMP _0x205
_0x206:
;}
	JMP  _0x20C0005
;
;void clear_block(char x,char y){
_clear_block:
;if(x>16 || y>4) return;
;	x -> Y+1
;	y -> Y+0
	LDD  R26,Y+1
	CPI  R26,LOW(0x11)
	BRSH _0x20C
	LD   R26,Y
	CPI  R26,LOW(0x5)
	BRLO _0x20B
_0x20C:
	JMP  _0x20C0003
;block[y] &= ~(1<<(x/2));
_0x20B:
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-_block)
	SBCI R31,HIGH(-_block)
	__PUTW1R 23,24
	LD   R22,Z
	LDD  R26,Y+1
	LDI  R27,0
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __DIVW21
	LDI  R26,LOW(1)
	CALL __LSLB12
	COM  R30
	AND  R30,R22
	__GETW2R 23,24
	ST   X,R30
;}
	JMP  _0x20C0003
;
;char is_block(char x,char y){
_is_block:
;return ((block[y]&(1<<(x/2)))!=0) ? 1:0;
;	x -> Y+1
;	y -> Y+0
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-_block)
	SBCI R31,HIGH(-_block)
	LD   R22,Z
	LDD  R26,Y+1
	LDI  R27,0
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __DIVW21
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R22
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x20E
	LDI  R30,LOW(1)
	RJMP _0x20F
_0x20E:
	LDI  R30,LOW(0)
_0x20F:
	JMP  _0x20C0003
;}
;
;
;void run_breakout(void){
_run_breakout:
;char bx,by,bx1,by1;
;char dx,dy;
;char px,sor;
;char blevel;
;
;
;bx=2;
	SBIW R28,3
	CALL __SAVELOCR6
;	bx -> R17
;	by -> R16
;	bx1 -> R19
;	by1 -> R18
;	dx -> R21
;	dy -> R20
;	px -> Y+8
;	sor -> Y+7
;	blevel -> Y+6
	LDI  R17,LOW(2)
;by=4;
	LDI  R16,LOW(4)
;dx=1;
	LDI  R21,LOW(1)
;dy=1;
	LDI  R20,LOW(1)
;px = 4;
	LDI  R30,LOW(4)
	STD  Y+8,R30
;sor=0;
	LDI  R30,LOW(0)
	STD  Y+7,R30
;blevel=0;
	STD  Y+6,R30
;overflow_t0 = 20; // FOr 200 ms
	LDI  R30,LOW(20)
	MOV  R7,R30
;ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;
;show_rocket(px,sor,1);
	LDD  R30,Y+8
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_rocket
;load_level(blevel);
	LDD  R30,Y+6
	ST   -Y,R30
	RCALL _load_level
;show_all_block();
	RCALL _show_all_block
;play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
;while(get_key_press(1<<BTN_EN) == 0){
_0x211:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE _0x213
;      if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x214
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x215
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x216
_0x215:
;                play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;      if (get_key_press(1<<BTN_ES)){
_0x216:
_0x214:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x217
;      light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;        return;
	RJMP _0x20C0009
;        }
;}
_0x217:
	RJMP _0x211
_0x213:
;
;while(1){
_0x218:
;
;
;    if(drop_timer_flag==1){
	LDS  R26,_drop_timer_flag_G000
	CPI  R26,LOW(0x1)
	BREQ PC+3
	JMP _0x21B
;
;    by1=by+dy;
	MOV  R30,R20
	ADD  R30,R16
	MOV  R18,R30
;    bx1=bx+dx;
	MOV  R30,R21
	ADD  R30,R17
	MOV  R19,R30
;
;    if(bx1>=15){
	CPI  R19,15
	BRLO _0x21C
;     bx1=15;
	LDI  R19,LOW(15)
;     dx=-1;
	LDI  R21,LOW(255)
;    }
;
;    if(bx1<=0){
_0x21C:
	TST  R19
	BRNE _0x21D
;     bx1=0;
	LDI  R19,LOW(0)
;     dx=1;
	LDI  R21,LOW(1)
;    }
;
;    if(by1>7){
_0x21D:
	CPI  R18,8
	BRLO _0x21E
;     by1=7;
	LDI  R18,LOW(7)
;     dy=-1;
	LDI  R20,LOW(255)
;    }
;
;    if(by1<=0){
_0x21E:
	TST  R18
	BRNE _0x21F
;     by1=0;
	LDI  R18,LOW(0)
;     dy=1;
	LDI  R20,LOW(1)
;    }
;
;    if(by1<=3){  // check For Brock Block
_0x21F:
	CPI  R18,4
	BRLO PC+3
	JMP _0x220
;     if(is_block(bx1,by1)){
	ST   -Y,R19
	ST   -Y,R18
	RCALL _is_block
	CPI  R30,0
	BREQ _0x221
;       clear_block(bx1,by1);
	ST   -Y,R19
	ST   -Y,R18
	RCALL _clear_block
;       show_block((bx1/2)*16,by1, 0);
	MOV  R26,R19
	LDI  R27,0
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __DIVW21
	LDI  R26,LOW(16)
	MULS R30,R26
	ST   -Y,R0
	ST   -Y,R18
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _show_block
;       paly_sound_key(tetris_one);
	LDI  R30,LOW(_tetris_one*2)
	LDI  R31,HIGH(_tetris_one*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       bx1=bx;
	MOV  R19,R17
;       by1=by;
	MOV  R18,R16
;       dx=(dx==1)? -1:1;
	CPI  R21,1
	BRNE _0x222
	LDI  R30,LOW(255)
	RJMP _0x223
_0x222:
	LDI  R30,LOW(1)
_0x223:
	MOV  R21,R30
;       dy=(dy==1)? -1:1;
	CPI  R20,1
	BRNE _0x225
	LDI  R30,LOW(255)
	RJMP _0x226
_0x225:
	LDI  R30,LOW(1)
_0x226:
	MOV  R20,R30
;
;        if(bx1==0 && dx==255)  dx=1;
	CPI  R19,0
	BRNE _0x229
	CPI  R21,255
	BREQ _0x22A
_0x229:
	RJMP _0x228
_0x22A:
	LDI  R21,LOW(1)
;        if(by1==0 && dy==255)  dy=1;
_0x228:
	CPI  R18,0
	BRNE _0x22C
	CPI  R20,255
	BREQ _0x22D
_0x22C:
	RJMP _0x22B
_0x22D:
	LDI  R20,LOW(1)
;
;
;     }
_0x22B:
;
;        // Check Win Game
;     if(Win_Game()){
_0x221:
	RCALL _Win_Game
	CPI  R30,0
	BRNE PC+3
	JMP _0x22E
;      if(++blevel<=9){
	LDD  R26,Y+6
	SUBI R26,-LOW(1)
	STD  Y+6,R26
	CPI  R26,LOW(0xA)
	BRLO PC+3
	JMP _0x22F
;            show_ball(bx,by,0);
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _show_ball
;
;            bx=2;
	LDI  R17,LOW(2)
;            by=4;
	LDI  R16,LOW(4)
;            bx1=2;
	LDI  R19,LOW(2)
;            by1=4;
	LDI  R18,LOW(4)
;            dx=1;
	LDI  R21,LOW(1)
;            dy=1;
	LDI  R20,LOW(1)
;            px = 4;
	LDI  R30,LOW(4)
	STD  Y+8,R30
;            sor=0;
	LDI  R30,LOW(0)
	STD  Y+7,R30
;            lputsf(40,2,"You Won!");
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__POINTW1FN _0x0,104
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;            lputsf(2,4,"Press Enter For level");
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	__POINTW1FN _0x0,113
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;            put_char((128-5)/2,6,48+blevel);
	LDI  R30,LOW(61)
	ST   -Y,R30
	LDI  R30,LOW(6)
	ST   -Y,R30
	LDD  R30,Y+8
	SUBI R30,-LOW(48)
	ST   -Y,R30
	CALL _put_char
;
;            while(get_key_press(1<<BTN_EN)==0){
_0x230:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE _0x232
;                  if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x233
;                 if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x234
;                    stop_sound();
	CALL _stop_sound
;                else
	RJMP _0x235
_0x234:
;                    play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;                  if (get_key_press(1<<BTN_ES)){
_0x235:
_0x233:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x236
;                  light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;                    return;
	RJMP _0x20C0009
;                    }
;            }
_0x236:
	RJMP _0x230
_0x232:
;
;            ks0108_ClearScreen();
	RJMP _0x27D
;            show_ball(bx1,by1,1);
;            show_rocket(px,sor,1);
;            load_level(blevel);
;            show_all_block();
;
;
;      }else{   // End OF Game
_0x22F:
;       blevel=0;
	LDI  R30,LOW(0)
	STD  Y+6,R30
;                   ks0108_ClearScreen();
_0x27D:
	CALL _ks0108_ClearScreen
;            show_ball(bx1,by1,1);
	ST   -Y,R19
	ST   -Y,R18
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_ball
;            show_rocket(px,sor,1);
	LDD  R30,Y+8
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_rocket
;            load_level(blevel);
	LDD  R30,Y+6
	ST   -Y,R30
	RCALL _load_level
;            show_all_block();
	RCALL _show_all_block
;      }
;
;
;     }
;
;
;    }
_0x22E:
;
;    if(by1>=7 && dy==1){  // Check For Roket
_0x220:
	CPI  R18,7
	BRLO _0x239
	CPI  R20,1
	BREQ _0x23A
_0x239:
	RJMP _0x238
_0x23A:
;
;       if(bx==px || bx==(px+1)){
	LDD  R30,Y+8
	CP   R30,R17
	BREQ _0x23C
	LDI  R31,0
	ADIW R30,1
	MOV  R26,R17
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x23B
_0x23C:
;            by1=by;
	MOV  R18,R16
;            dy=-1;
	LDI  R20,LOW(255)
;            if(sor==0){
	LDD  R30,Y+7
	CPI  R30,0
	BRNE _0x23E
;                bx1=bx;
	MOV  R19,R17
;                by1=by+dy;
	MOV  R30,R20
	ADD  R30,R16
	MOV  R18,R30
;                bx1=bx+dx;
	MOV  R30,R21
	ADD  R30,R17
	MOV  R19,R30
;            }else{
	RJMP _0x23F
_0x23E:
;                sor=0;
	LDI  R30,LOW(0)
	STD  Y+7,R30
;                show_rocket(px,sor,1);
	LDD  R30,Y+8
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_rocket
;                //show_ball(bx,by,0);
;                //show_ball(bx1,by1,1);
;                }
_0x23F:
;
;        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       }else if((bx+1)==px || (bx-1)==(px+1)){
	RJMP _0x240
_0x23B:
	MOV  R30,R17
	LDI  R31,0
	MOVW R0,R30
	ADIW R30,1
	MOVW R26,R30
	LDD  R30,Y+8
	LDI  R31,0
	CP   R30,R26
	CPC  R31,R27
	BREQ _0x242
	MOVW R26,R0
	SBIW R26,1
	LDD  R30,Y+8
	LDI  R31,0
	ADIW R30,1
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x241
_0x242:
;            by1=by;
	MOV  R18,R16
;            bx1=bx;
	MOV  R19,R17
;            dy=-1;
	LDI  R20,LOW(255)
;            dx=(dx==1)? -1:1;
	CPI  R21,1
	BRNE _0x244
	LDI  R30,LOW(255)
	RJMP _0x245
_0x244:
	LDI  R30,LOW(1)
_0x245:
	MOV  R21,R30
;                by1=by+dy;
	MOV  R30,R20
	ADD  R30,R16
	MOV  R18,R30
;                bx1=bx+dx;
	MOV  R30,R21
	ADD  R30,R17
	MOV  R19,R30
;
;        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;       }else{   // LOSE
	RJMP _0x247
_0x241:
;
;                show_ball(bx,by,0);
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _show_ball
;                show_ball(bx1,by1,1);
	ST   -Y,R19
	ST   -Y,R18
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_ball
;        lputsf(35,3,"Game Over!");
	LDI  R30,LOW(35)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__POINTW1FN _0x0,135
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;        lputsf(12,5,"Press ESC To Exit.");
	LDI  R30,LOW(12)
	ST   -Y,R30
	LDI  R30,LOW(5)
	ST   -Y,R30
	__POINTW1FN _0x0,146
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;        while(get_key_press(1<<BTN_ES)==0){
_0x248:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE _0x24A
;        if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x24B
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x24C
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x24D
_0x24C:
;                play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;        }
_0x24D:
_0x24B:
	RJMP _0x248
_0x24A:
;
;        light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;        break;
	RJMP _0x21A
;        }
_0x247:
_0x240:
;
;
;    }
;    show_ball(bx,by,0);
_0x238:
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _show_ball
;    show_ball(bx1,by1,1);
	ST   -Y,R19
	ST   -Y,R18
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_ball
;    bx=bx1;
	MOV  R17,R19
;    by=by1;
	MOV  R16,R18
;    drop_timer_flag=0;
	LDI  R30,LOW(0)
	STS  _drop_timer_flag_G000,R30
;    }
;
;
;    if(get_key_press(1<<BTN_LT)){
_0x21B:
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x24E
;
;        if(px-1>=0){
	LDD  R30,Y+8
	LDI  R31,0
	SBIW R30,1
	TST  R31
	BRMI _0x24F
;        show_rocket(px--,sor,0);// Clear Rocket
	LDD  R30,Y+8
	SUBI R30,LOW(1)
	STD  Y+8,R30
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _show_rocket
;        show_rocket(px,sor,1);
	LDD  R30,Y+8
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_rocket
;        }
;    }
_0x24F:
;
;    if(get_key_press(1<<BTN_UP)){
_0x24E:
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x250
;     sor=1;
	LDI  R30,LOW(1)
	STD  Y+7,R30
;     show_rocket(px,sor,1);
	LDD  R30,Y+8
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_rocket
;    }
;
;    if(get_key_press(1<<BTN_RT)){
_0x250:
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x251
;
;        if(px+1<=14){
	LDD  R30,Y+8
	LDI  R31,0
	ADIW R30,1
	SBIW R30,15
	BRGE _0x252
;        show_rocket(px++,sor,0);// Clear Rocket
	LDD  R30,Y+8
	SUBI R30,-LOW(1)
	STD  Y+8,R30
	SUBI R30,LOW(1)
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _show_rocket
;        show_rocket(px,sor,1);
	LDD  R30,Y+8
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _show_rocket
;        }
;    }
_0x252:
;
;    if (get_key_press(1<<BTN_ES)){
_0x251:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x253
;        light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;
;        break;
	RJMP _0x21A
;        }
;
;          if (get_key_press(1<<BTN_MD))
_0x253:
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x254
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x255
;                stop_sound();
	CALL _stop_sound
;           else
	RJMP _0x256
_0x255:
;                play_sound(tetris_sound);
	LDI  R30,LOW(_tetris_sound*2)
	LDI  R31,HIGH(_tetris_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;};
_0x256:
_0x254:
	RJMP _0x218
_0x21A:
;
;}
_0x20C0009:
	CALL __LOADLOCR6
	ADIW R28,9
	RET
;#include "menu.c"
;//menu
;#define MENU_ITEM   4
;flash char *menu_pic[]={maze_logo,tetris_logo,puzzle_logo,breakout_logo};

	.DSEG
;char ci=0;
;
;void start_menu(){
; 0000 002A void start_menu(){

	.CSEG
_start_menu:
;
;char i;
;flash char *curnet_pic=menu_pic[ci];
;ks0108_ClearScreen();
	CALL __SAVELOCR4
;	i -> R17
;	*curnet_pic -> R18,R19
	LDS  R30,_ci
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R18,R30
	CALL _ks0108_ClearScreen
;for(i=1;i<8;i++){
	LDI  R17,LOW(1)
_0x259:
	CPI  R17,8
	BRSH _0x25A
;ks0108_gotoxy(23,i);
	LDI  R30,LOW(23)
	ST   -Y,R30
	ST   -Y,R17
	CALL _ks0108_gotoxy
;ks0108_Write(255);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;ks0108_gotoxy(104,i);
	LDI  R30,LOW(104)
	ST   -Y,R30
	ST   -Y,R17
	CALL _ks0108_gotoxy
;ks0108_Write(255);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;}
	SUBI R17,-1
	RJMP _0x259
_0x25A:
;show_but(2,4,PERV);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _show_but
;show_but(108,4,NEXT);
	LDI  R30,LOW(108)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _show_but
;show_pic(curnet_pic,24,1,0);
	ST   -Y,R19
	ST   -Y,R18
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _show_pic
;play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;}
_0x20C0008:
	CALL __LOADLOCR4
_0x20C0007:
	ADIW R28,4
	RET
;
;void Show_game_menu(){
_Show_game_menu:
;
;light_off(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
;start_menu();
	RCALL _start_menu
;light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
;
;while(1){
_0x25B:
;
;       if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x25E
;            if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x25F
;                stop_sound();
	CALL _stop_sound
;            else
	RJMP _0x260
_0x25F:
;                play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;
;       if (get_key_press(1<<BTN_RT)){  // next Item
_0x260:
_0x25E:
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x261
;            if(ci<MENU_ITEM-1){
	LDS  R26,_ci
	CPI  R26,LOW(0x3)
	BRSH _0x262
;                show_but(108,4,NEXT1);
	LDI  R30,LOW(108)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _show_but
;                paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;                show_but(108,4,NEXT);
	LDI  R30,LOW(108)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _show_but
;                echange_left(menu_pic[ci++],menu_pic[ci], 24,1);
	LDS  R30,_ci
	SUBI R30,-LOW(1)
	STS  _ci,R30
	SUBI R30,LOW(1)
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDS  R30,_ci
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _echange_left
;                }
;        }
_0x262:
;
;       if (get_key_press(1<<BTN_LT)){// Prev item
_0x261:
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x263
;            if(ci>0){
	LDS  R26,_ci
	CPI  R26,LOW(0x1)
	BRLO _0x264
;                show_but(2,4,PERV1);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	CALL _show_but
;                paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;                show_but(2,4,PERV);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _show_but
;                echange_right(menu_pic[ci--],menu_pic[ci], 24,1);
	LDS  R26,_ci
	SUBI R26,LOW(1)
	STS  _ci,R26
	LDI  R27,0
	LSL  R26
	ROL  R27
	__ADDW2MN _menu_pic,2
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDS  R30,_ci
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _echange_right
;            }
;        }
_0x264:
;
;        if (get_key_press(1<<BTN_EN)){
_0x263:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x265
;           paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;           switch(ci){
	LDS  R30,_ci
	LDI  R31,0
;
;           case 0: light_off(120);Run_maze(); break;
	SBIW R30,0
	BRNE _0x269
	LDI  R30,LOW(120)
	LDI  R31,HIGH(120)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
	CALL _Run_maze
	RJMP _0x268
;           case 1: light_off(120);Run_tetris(); break;
_0x269:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x26A
	LDI  R30,LOW(120)
	LDI  R31,HIGH(120)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
	RCALL _Run_tetris
	RJMP _0x268
;           case 2: light_off(120);run_puzzle(); break;
_0x26A:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x26B
	LDI  R30,LOW(120)
	LDI  R31,HIGH(120)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
	RCALL _run_puzzle
	RJMP _0x268
;           case 3: light_off(120);run_breakout(); break;
_0x26B:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x268
	LDI  R30,LOW(120)
	LDI  R31,HIGH(120)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_off
	RCALL _run_breakout
;           }
_0x268:
;           start_menu();
	RCALL _start_menu
;           light_on(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
;        }
;
;}
_0x265:
	RJMP _0x25B
;
;}
;
;
;
;
;
;
;
;
;
;void main(void)
; 0000 0031 {
_main:
; 0000 0032 
; 0000 0033 
; 0000 0034 ks0108_Init();
	CALL _ks0108_Init
; 0000 0035 ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
; 0000 0036 sound_init();
	CALL _sound_init
; 0000 0037 Key_init();
	CALL _Key_init
; 0000 0038 init_timer0();
	CALL _init_timer0
; 0000 0039 init_spwm();
	CALL _init_spwm
; 0000 003A #asm("sei");
	sei
; 0000 003B show_pic(agape_logo,0,0,50);
	LDI  R30,LOW(_agape_logo*2)
	LDI  R31,HIGH(_agape_logo*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	LDI  R30,LOW(50)
	ST   -Y,R30
	CALL _show_pic
; 0000 003C play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
; 0000 003D light_on(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	ST   -Y,R31
	ST   -Y,R30
	CALL _light_on
; 0000 003E 
; 0000 003F 
; 0000 0040 while (1)
_0x26D:
; 0000 0041       {
; 0000 0042        if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x270
; 0000 0043             if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BRNE _0x271
; 0000 0044                 stop_sound();
	CALL _stop_sound
; 0000 0045            else
	RJMP _0x272
_0x271:
; 0000 0046                 play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
; 0000 0047 
; 0000 0048        if (get_key_press(1<<BTN_EN))
_0x272:
_0x270:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BREQ _0x273
; 0000 0049             Show_game_menu();
	RCALL _Show_game_menu
; 0000 004A 
; 0000 004B       };
_0x273:
	RJMP _0x26D
; 0000 004C }
_0x274:
	RJMP _0x274
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_ks0108_InitHW:
	CBI  0x15,7
	CBI  0x15,6
	CBI  0x15,5
	CBI  0x15,4
	CBI  0x15,3
	CBI  0x15,1
	CBI  0x15,1
	CBI  0x15,2
	SBI  0x14,7
	SBI  0x14,6
	SBI  0x14,5
	SBI  0x14,4
	SBI  0x14,3
	SBI  0x14,1
	SBI  0x14,1
	SBI  0x14,2
	LDI  R30,LOW(0)
	OUT  0x1B,R30
	LDI  R30,LOW(255)
	OUT  0x1A,R30
	RET
_ks0108_ControllerSelect:
	CBI  0x15,4
	CBI  0x15,3
	CBI  0x15,1
	CBI  0x15,1
	LD   R30,Y
	LDI  R31,0
	SBIW R30,0
	BRNE _0x2000006
	SBI  0x15,4
	RJMP _0x2000005
_0x2000006:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x2000007
	SBI  0x15,3
	RJMP _0x2000005
_0x2000007:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x2000008
	SBI  0x15,1
	RJMP _0x2000005
_0x2000008:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x200000A
	SBI  0x15,1
_0x200000A:
_0x2000005:
	RJMP _0x20C0004
_ks0108_BusyWait:
	LD   R30,Y
	ST   -Y,R30
	RCALL _ks0108_ControllerSelect
	LDI  R30,LOW(255)
	OUT  0x1B,R30
	CBI  0x15,7
	LDI  R30,LOW(0)
	OUT  0x1A,R30
	SBI  0x15,6
	SBI  0x15,5
        nop
        nop
_0x200000B:
	SBIS 0x19,7
	RJMP _0x200000D
	CBI  0x15,5
        nop
        nop
	SBI  0x15,5
        nop
        nop
	RJMP _0x200000B
_0x200000D:
	CBI  0x15,5
	CBI  0x15,6
	LDI  R30,LOW(255)
	OUT  0x1A,R30
	RJMP _0x20C0004
_ks0108_ControlWrite:
	LDD  R30,Y+1
	ST   -Y,R30
	RCALL _ks0108_BusyWait
	CBI  0x15,7
	CBI  0x15,6
	SBI  0x15,5
	LDI  R30,LOW(255)
	OUT  0x1A,R30
	LD   R30,Y
	OUT  0x1B,R30
	CBI  0x15,5
	RJMP _0x20C0003
_ks0108_Write:
	ST   -Y,R17
	LDS  R26,_GrLcdState_G100
	LDI  R27,0
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	CALL __DIVW21
	MOV  R17,R30
	ST   -Y,R17
	RCALL _ks0108_BusyWait
	SBI  0x15,7
	CBI  0x15,6
	SBI  0x15,5
	LDI  R30,LOW(255)
	OUT  0x1A,R30
	LDD  R30,Y+1
	OUT  0x1B,R30
	CBI  0x15,5
	__POINTW2MN _GrLcdState_G100,2
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	SUBI R30,-LOW(1)
	ST   X,R30
	LDS  R30,_GrLcdState_G100
	SUBI R30,-LOW(1)
	STS  _GrLcdState_G100,R30
	LDS  R26,_GrLcdState_G100
	CPI  R26,LOW(0x80)
	BRLO _0x200000E
	__GETB1MN _GrLcdState_G100,1
	SUBI R30,-LOW(1)
	__PUTB1MN _GrLcdState_G100,1
	SUBI R30,LOW(1)
	__GETB1MN _GrLcdState_G100,1
	ST   -Y,R30
	RCALL _ks0108_SetYAddress
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _ks0108_SetXAddress
_0x200000E:
	LDD  R17,Y+0
	RJMP _0x20C0003
_ks0108_SetXAddress:
	ST   -Y,R17
	LDD  R30,Y+1
	STS  _GrLcdState_G100,R30
	LDI  R17,LOW(0)
_0x2000010:
	CPI  R17,2
	BRSH _0x2000011
	ST   -Y,R17
	LDI  R30,LOW(64)
	ST   -Y,R30
	RCALL _ks0108_ControlWrite
	__POINTW2MN _GrLcdState_G100,2
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(0)
	ST   X,R30
	SUBI R17,-1
	RJMP _0x2000010
_0x2000011:
	LDS  R26,_GrLcdState_G100
	LDI  R27,0
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	CALL __DIVW21
	ST   -Y,R30
	LDS  R30,_GrLcdState_G100
	ANDI R30,LOW(0x3F)
	ORI  R30,0x40
	ST   -Y,R30
	RCALL _ks0108_ControlWrite
	LDD  R17,Y+0
	RJMP _0x20C0003
_ks0108_SetYAddress:
	ST   -Y,R17
	LDD  R30,Y+1
	__PUTB1MN _GrLcdState_G100,1
	LDI  R17,LOW(0)
_0x2000013:
	CPI  R17,2
	BRSH _0x2000014
	ST   -Y,R17
	LDD  R30,Y+2
	ORI  R30,LOW(0xB8)
	ST   -Y,R30
	RCALL _ks0108_ControlWrite
	SUBI R17,-1
	RJMP _0x2000013
_0x2000014:
	LDD  R17,Y+0
	RJMP _0x20C0003
_ks0108_Reset:
	LD   R30,Y
	CPI  R30,0
	BREQ _0x2000016
	CBI  0x15,2
	RJMP _0x2000017
_0x2000016:
	SBI  0x15,2
_0x2000017:
	RJMP _0x20C0004
_ks0108_Init:
	ST   -Y,R17
	RCALL _ks0108_InitHW
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _ks0108_Reset
	LDI  R17,LOW(0)
_0x2000019:
	CPI  R17,2
	BRSH _0x200001A
	ST   -Y,R17
	LDI  R30,LOW(63)
	ST   -Y,R30
	RCALL _ks0108_ControlWrite
	SUBI R17,-1
	RJMP _0x2000019
_0x200001A:
	RCALL _ks0108_ClearScreen
	RCALL _ks0108_Home
	RJMP _0x20C0006
_ks0108_Home:
	ST   -Y,R17
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _ks0108_StartLine
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	RCALL _ks0108_SetAddress
	LDI  R17,LOW(0)
_0x200001C:
	CPI  R17,2
	BRSH _0x200001D
	__POINTW2MN _GrLcdState_G100,2
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(0)
	ST   X,R30
	__POINTW2MN _GrLcdState_G100,2
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	ADIW R26,1
	LDI  R30,LOW(0)
	ST   X,R30
	SUBI R17,-1
	RJMP _0x200001C
_0x200001D:
_0x20C0006:
	LD   R17,Y+
	RET
_ks0108_ClearScreen:
	ST   -Y,R17
	ST   -Y,R16
	LDI  R17,LOW(0)
_0x200001F:
	CPI  R17,8
	BRSH _0x2000020
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R17
	RCALL _ks0108_SetAddress
	LDI  R16,LOW(0)
_0x2000022:
	CPI  R16,128
	BRSH _0x2000023
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _ks0108_Write
	SUBI R16,-1
	RJMP _0x2000022
_0x2000023:
	SUBI R17,-1
	RJMP _0x200001F
_0x2000020:
_0x20C0005:
	LD   R16,Y+
	LD   R17,Y+
	RET
_ks0108_StartLine:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDD  R30,Y+1
	ORI  R30,LOW(0xC0)
	ST   -Y,R30
	RCALL _ks0108_ControlWrite
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDD  R30,Y+1
	ORI  R30,LOW(0xC0)
	ST   -Y,R30
	RCALL _ks0108_ControlWrite
_0x20C0004:
	ADIW R28,1
	RET
_ks0108_SetAddress:
_ks0108_gotoxy:
_0x20C0002:
	LD   R30,Y
	ST   -Y,R30
	RCALL _ks0108_SetYAddress
	LDD  R30,Y+1
	ST   -Y,R30
	RCALL _ks0108_SetXAddress
_0x20C0003:
	ADIW R28,2
	RET
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_put_buff_G101:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x2020010
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,4
	CALL __GETW1P
	MOVW R16,R30
	SBIW R30,0
	BREQ _0x2020012
	__CPWRN 16,17,2
	BRLO _0x2020013
	MOVW R30,R16
	SBIW R30,1
	MOVW R16,R30
	__PUTW1SNS 2,4
_0x2020012:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	SBIW R30,1
	LDD  R26,Y+4
	STD  Z+0,R26
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	CALL __GETW1P
	TST  R31
	BRMI _0x2020014
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
_0x2020014:
_0x2020013:
	RJMP _0x2020015
_0x2020010:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	ST   X+,R30
	ST   X,R31
_0x2020015:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
__print_G101:
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R17,0
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
_0x2020016:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ADIW R30,1
	STD  Y+18,R30
	STD  Y+18+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R18,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x2020018
	MOV  R30,R17
	CPI  R30,0
	BRNE _0x202001C
	CPI  R18,37
	BRNE _0x202001D
	LDI  R17,LOW(1)
	RJMP _0x202001E
_0x202001D:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
_0x202001E:
	RJMP _0x202001B
_0x202001C:
	CPI  R30,LOW(0x1)
	BRNE _0x202001F
	CPI  R18,37
	BRNE _0x2020020
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RJMP _0x20200C9
_0x2020020:
	LDI  R17,LOW(2)
	LDI  R20,LOW(0)
	LDI  R16,LOW(0)
	CPI  R18,45
	BRNE _0x2020021
	LDI  R16,LOW(1)
	RJMP _0x202001B
_0x2020021:
	CPI  R18,43
	BRNE _0x2020022
	LDI  R20,LOW(43)
	RJMP _0x202001B
_0x2020022:
	CPI  R18,32
	BRNE _0x2020023
	LDI  R20,LOW(32)
	RJMP _0x202001B
_0x2020023:
	RJMP _0x2020024
_0x202001F:
	CPI  R30,LOW(0x2)
	BRNE _0x2020025
_0x2020024:
	LDI  R21,LOW(0)
	LDI  R17,LOW(3)
	CPI  R18,48
	BRNE _0x2020026
	ORI  R16,LOW(128)
	RJMP _0x202001B
_0x2020026:
	RJMP _0x2020027
_0x2020025:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x202001B
_0x2020027:
	CPI  R18,48
	BRLO _0x202002A
	CPI  R18,58
	BRLO _0x202002B
_0x202002A:
	RJMP _0x2020029
_0x202002B:
	LDI  R26,LOW(10)
	MUL  R21,R26
	MOV  R21,R0
	MOV  R30,R18
	SUBI R30,LOW(48)
	ADD  R21,R30
	RJMP _0x202001B
_0x2020029:
	MOV  R30,R18
	CPI  R30,LOW(0x63)
	BRNE _0x202002F
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Z+4
	ST   -Y,R26
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RJMP _0x2020030
_0x202002F:
	CPI  R30,LOW(0x73)
	BRNE _0x2020032
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlen
	MOV  R17,R30
	RJMP _0x2020033
_0x2020032:
	CPI  R30,LOW(0x70)
	BRNE _0x2020035
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	MOV  R17,R30
	ORI  R16,LOW(8)
_0x2020033:
	ORI  R16,LOW(2)
	ANDI R16,LOW(127)
	LDI  R19,LOW(0)
	RJMP _0x2020036
_0x2020035:
	CPI  R30,LOW(0x64)
	BREQ _0x2020039
	CPI  R30,LOW(0x69)
	BRNE _0x202003A
_0x2020039:
	ORI  R16,LOW(4)
	RJMP _0x202003B
_0x202003A:
	CPI  R30,LOW(0x75)
	BRNE _0x202003C
_0x202003B:
	LDI  R30,LOW(_tbl10_G101*2)
	LDI  R31,HIGH(_tbl10_G101*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(5)
	RJMP _0x202003D
_0x202003C:
	CPI  R30,LOW(0x58)
	BRNE _0x202003F
	ORI  R16,LOW(8)
	RJMP _0x2020040
_0x202003F:
	CPI  R30,LOW(0x78)
	BREQ PC+3
	JMP _0x2020071
_0x2020040:
	LDI  R30,LOW(_tbl16_G101*2)
	LDI  R31,HIGH(_tbl16_G101*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(4)
_0x202003D:
	SBRS R16,2
	RJMP _0x2020042
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDD  R26,Y+11
	TST  R26
	BRPL _0x2020043
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R20,LOW(45)
_0x2020043:
	CPI  R20,0
	BREQ _0x2020044
	SUBI R17,-LOW(1)
	RJMP _0x2020045
_0x2020044:
	ANDI R16,LOW(251)
_0x2020045:
	RJMP _0x2020046
_0x2020042:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
_0x2020046:
_0x2020036:
	SBRC R16,0
	RJMP _0x2020047
_0x2020048:
	CP   R17,R21
	BRSH _0x202004A
	SBRS R16,7
	RJMP _0x202004B
	SBRS R16,2
	RJMP _0x202004C
	ANDI R16,LOW(251)
	MOV  R18,R20
	SUBI R17,LOW(1)
	RJMP _0x202004D
_0x202004C:
	LDI  R18,LOW(48)
_0x202004D:
	RJMP _0x202004E
_0x202004B:
	LDI  R18,LOW(32)
_0x202004E:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	SUBI R21,LOW(1)
	RJMP _0x2020048
_0x202004A:
_0x2020047:
	MOV  R19,R17
	SBRS R16,1
	RJMP _0x202004F
_0x2020050:
	CPI  R19,0
	BREQ _0x2020052
	SBRS R16,3
	RJMP _0x2020053
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LPM  R18,Z+
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x2020054
_0x2020053:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R18,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x2020054:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	CPI  R21,0
	BREQ _0x2020055
	SUBI R21,LOW(1)
_0x2020055:
	SUBI R19,LOW(1)
	RJMP _0x2020050
_0x2020052:
	RJMP _0x2020056
_0x202004F:
_0x2020058:
	LDI  R18,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x202005A:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x202005C
	SUBI R18,-LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x202005A
_0x202005C:
	CPI  R18,58
	BRLO _0x202005D
	SBRS R16,3
	RJMP _0x202005E
	SUBI R18,-LOW(7)
	RJMP _0x202005F
_0x202005E:
	SUBI R18,-LOW(39)
_0x202005F:
_0x202005D:
	SBRC R16,4
	RJMP _0x2020061
	CPI  R18,49
	BRSH _0x2020063
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,1
	BRNE _0x2020062
_0x2020063:
	RJMP _0x20200CA
_0x2020062:
	CP   R21,R19
	BRLO _0x2020067
	SBRS R16,0
	RJMP _0x2020068
_0x2020067:
	RJMP _0x2020066
_0x2020068:
	LDI  R18,LOW(32)
	SBRS R16,7
	RJMP _0x2020069
	LDI  R18,LOW(48)
_0x20200CA:
	ORI  R16,LOW(16)
	SBRS R16,2
	RJMP _0x202006A
	ANDI R16,LOW(251)
	ST   -Y,R20
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	CPI  R21,0
	BREQ _0x202006B
	SUBI R21,LOW(1)
_0x202006B:
_0x202006A:
_0x2020069:
_0x2020061:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	CPI  R21,0
	BREQ _0x202006C
	SUBI R21,LOW(1)
_0x202006C:
_0x2020066:
	SUBI R19,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,2
	BRLO _0x2020059
	RJMP _0x2020058
_0x2020059:
_0x2020056:
	SBRS R16,0
	RJMP _0x202006D
_0x202006E:
	CPI  R21,0
	BREQ _0x2020070
	SUBI R21,LOW(1)
	LDI  R30,LOW(32)
	ST   -Y,R30
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RJMP _0x202006E
_0x2020070:
_0x202006D:
_0x2020071:
_0x2020030:
_0x20200C9:
	LDI  R17,LOW(0)
_0x202001B:
	RJMP _0x2020016
_0x2020018:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	CALL __GETW1P
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_sprintf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	CALL __SAVELOCR4
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	SBIW R30,0
	BRNE _0x2020072
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	RJMP _0x20C0001
_0x2020072:
	MOVW R26,R28
	ADIW R26,6
	CALL __ADDW2R15
	MOVW R16,R26
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R30,LOW(0)
	STD  Y+8,R30
	STD  Y+8+1,R30
	MOVW R26,R28
	ADIW R26,10
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(_put_buff_G101)
	LDI  R31,HIGH(_put_buff_G101)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G101
	MOVW R18,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
	MOVW R30,R18
_0x20C0001:
	CALL __LOADLOCR4
	ADIW R28,10
	POP  R15
	RET

	.CSEG

	.DSEG

	.CSEG

	.CSEG

	.CSEG

	.CSEG
_strlen:
    ld   r26,y+
    ld   r27,y+
    clr  r30
    clr  r31
strlen0:
    ld   r22,x+
    tst  r22
    breq strlen1
    adiw r30,1
    rjmp strlen0
strlen1:
    ret
_strlenf:
    clr  r26
    clr  r27
    ld   r30,y+
    ld   r31,y+
strlenf0:
	lpm  r0,z+
    tst  r0
    breq strlenf1
    adiw r26,1
    rjmp strlenf0
strlenf1:
    movw r30,r26
    ret

	.DSEG
_Tone_G000:
	.BYTE 0x1
_Tempo_G000:
	.BYTE 0x1
_Duration_G000:
	.BYTE 0x1
_key_press:
	.BYTE 0x1
_timer_down_G000:
	.BYTE 0x1
_drop_timer_flag_G000:
	.BYTE 0x1
_ct0_S0000010000:
	.BYTE 0x1
_ct1_S0000010000:
	.BYTE 0x1
_maze:
	.BYTE 0xC
_BOX_piece:
	.BYTE 0x4
_BOX_location:
	.BYTE 0x24
_image_part:
	.BYTE 0x20
_homes:
	.BYTE 0x20
_empty_id:
	.BYTE 0x1
_pic:
	.BYTE 0x2
_block:
	.BYTE 0x4
_menu_pic:
	.BYTE 0x8
_ci:
	.BYTE 0x1
_GrLcdState_G100:
	.BYTE 0x6
__seed_G102:
	.BYTE 0x4

	.CSEG

	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__LSLB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSLB12R
__LSLB12L:
	LSL  R30
	DEC  R0
	BRNE __LSLB12L
__LSLB12R:
	RET

__LSLW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSLW12R
__LSLW12L:
	LSL  R30
	ROL  R31
	DEC  R0
	BRNE __LSLW12L
__LSLW12R:
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__EQB12:
	CP   R30,R26
	LDI  R30,1
	BREQ __EQB12T
	CLR  R30
__EQB12T:
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__MULW12:
	RCALL __CHKSIGNW
	RCALL __MULW12U
	BRTC __MULW121
	RCALL __ANEGW1
__MULW121:
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__MODW21:
	CLT
	SBRS R27,7
	RJMP __MODW211
	COM  R26
	COM  R27
	ADIW R26,1
	SET
__MODW211:
	SBRC R31,7
	RCALL __ANEGW1
	RCALL __DIVW21U
	MOVW R30,R26
	BRTC __MODW212
	RCALL __ANEGW1
__MODW212:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
